/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.cloud.grpc.GcpManagedChannel;
import com.google.cloud.grpc.GcpManagedChannelOptions;
import com.google.cloud.grpc.GcpMultiEndpointOptions;
import com.google.cloud.grpc.multiendpoint.MultiEndpoint;
import com.google.cloud.grpc.proto.ApiConfig;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.ChannelCredentials;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class GcpMultiEndpointChannel
extends ManagedChannel {
    public static final CallOptions.Key<String> ME_KEY = CallOptions.Key.create((String)"MultiEndpoint");
    private final LabelKey endpointKey = LabelKey.create((String)"endpoint", (String)"Endpoint address.");
    private final Map<String, MultiEndpoint> multiEndpoints = new ConcurrentHashMap<String, MultiEndpoint>();
    private MultiEndpoint defaultMultiEndpoint;
    private final ApiConfig apiConfig;
    private final GcpManagedChannelOptions gcpManagedChannelOptions;
    private final Map<String, GcpManagedChannel> pools = new ConcurrentHashMap<String, GcpManagedChannel>();

    public GcpMultiEndpointChannel(List<GcpMultiEndpointOptions> meOptions, ApiConfig apiConfig, GcpManagedChannelOptions gcpManagedChannelOptions) {
        this.apiConfig = apiConfig;
        this.gcpManagedChannelOptions = gcpManagedChannelOptions;
        this.setMultiEndpoints(meOptions);
    }

    private ConnectivityState checkPoolState(ManagedChannel channel, String endpoint) {
        ConnectivityState state = channel.getState(false);
        for (MultiEndpoint me : this.multiEndpoints.values()) {
            me.setEndpointAvailable(endpoint, state.equals((Object)ConnectivityState.READY));
        }
        return state;
    }

    private GcpManagedChannelOptions prepareGcpManagedChannelConfig(GcpManagedChannelOptions gcpOptions, String endpoint) {
        GcpManagedChannelOptions.GcpMetricsOptions.Builder metricsOptions = GcpManagedChannelOptions.GcpMetricsOptions.newBuilder(gcpOptions.getMetricsOptions());
        ArrayList<LabelKey> labelKeys = new ArrayList<LabelKey>(metricsOptions.build().getLabelKeys());
        ArrayList<LabelValue> labelValues = new ArrayList<LabelValue>(metricsOptions.build().getLabelValues());
        labelKeys.add(this.endpointKey);
        labelValues.add(LabelValue.create((String)endpoint));
        GcpManagedChannelOptions.GcpChannelPoolOptions.Builder poolOptions = GcpManagedChannelOptions.GcpChannelPoolOptions.newBuilder(gcpOptions.getChannelPoolOptions());
        if (poolOptions.build().getMinSize() < 1) {
            int minSize = Math.min(2, poolOptions.build().getMaxSize());
            minSize = Math.max(minSize, (int)Math.sqrt(poolOptions.build().getMaxSize()));
            poolOptions.setMinSize(minSize);
        }
        return GcpManagedChannelOptions.newBuilder(gcpOptions).withChannelPoolOptions(poolOptions.build()).withMetricsOptions(metricsOptions.withLabels(labelKeys, labelValues).build()).build();
    }

    public void setMultiEndpoints(List<GcpMultiEndpointOptions> meOptions) {
        Preconditions.checkNotNull(meOptions);
        Preconditions.checkArgument((!meOptions.isEmpty() ? 1 : 0) != 0, (Object)"MultiEndpoints list is empty");
        HashSet currentMultiEndpoints = new HashSet();
        HashSet currentEndpoints = new HashSet();
        meOptions.forEach(options -> {
            currentMultiEndpoints.add(options.getName());
            if (this.multiEndpoints.containsKey(options.getName())) {
                this.multiEndpoints.get(options.getName()).setEndpoints(options.getEndpoints());
            } else {
                this.multiEndpoints.put(options.getName(), new MultiEndpoint.Builder(options.getEndpoints()).withRecoveryTimeout(options.getRecoveryTimeout()).build());
            }
        });
        meOptions.forEach(options -> options.getEndpoints().forEach(endpoint -> {
            currentEndpoints.add(endpoint);
            this.pools.computeIfAbsent((String)endpoint, e -> {
                ManagedChannelBuilder managedChannelBuilder;
                if (options.getChannelCredentials() != null) {
                    managedChannelBuilder = Grpc.newChannelBuilder((String)e, (ChannelCredentials)options.getChannelCredentials());
                } else {
                    int port;
                    String serviceAddress;
                    int colon = e.lastIndexOf(58);
                    if (colon < 0) {
                        serviceAddress = e;
                        port = 443;
                    } else {
                        serviceAddress = e.substring(0, colon);
                        port = Integer.parseInt(e.substring(colon + 1));
                    }
                    managedChannelBuilder = ManagedChannelBuilder.forAddress((String)serviceAddress, (int)port);
                }
                if (options.getChannelConfigurator() != null) {
                    managedChannelBuilder = (ManagedChannelBuilder)options.getChannelConfigurator().apply((Object)managedChannelBuilder);
                }
                GcpManagedChannel channel = new GcpManagedChannel(managedChannelBuilder, this.apiConfig, this.prepareGcpManagedChannelConfig(this.gcpManagedChannelOptions, (String)e));
                new EndpointStateMonitor(channel, (String)e);
                return channel;
            });
            this.checkPoolState(this.pools.get(endpoint), (String)endpoint);
        }));
        this.defaultMultiEndpoint = this.multiEndpoints.get(meOptions.get(0).getName());
        this.multiEndpoints.keySet().removeIf(name -> !currentMultiEndpoints.contains(name));
        for (String endpoint : this.pools.keySet()) {
            if (currentEndpoints.contains(endpoint)) continue;
            this.pools.get(endpoint).shutdown();
            this.pools.remove(endpoint);
        }
    }

    public ManagedChannel shutdown() {
        this.pools.values().forEach(GcpManagedChannel::shutdown);
        return this;
    }

    public boolean isShutdown() {
        return this.pools.values().stream().allMatch(GcpManagedChannel::isShutdown);
    }

    public boolean isTerminated() {
        return this.pools.values().stream().allMatch(GcpManagedChannel::isTerminated);
    }

    public ManagedChannel shutdownNow() {
        this.pools.values().forEach(GcpManagedChannel::shutdownNow);
        return this;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        for (GcpManagedChannel gcpManagedChannel : this.pools.values()) {
            if (gcpManagedChannel.isTerminated()) continue;
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            gcpManagedChannel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        String multiEndpointKey = (String)callOptions.getOption(ME_KEY);
        MultiEndpoint me = this.defaultMultiEndpoint;
        if (multiEndpointKey != null) {
            me = this.multiEndpoints.getOrDefault(multiEndpointKey, this.defaultMultiEndpoint);
        }
        return this.pools.get(me.getCurrentId()).newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.pools.get(this.defaultMultiEndpoint.getCurrentId()).authority();
    }

    public String authorityFor(String multiEndpointName) {
        MultiEndpoint multiEndpoint = this.multiEndpoints.get(multiEndpointName);
        if (multiEndpoint == null) {
            return null;
        }
        return this.pools.get(multiEndpoint.getCurrentId()).authority();
    }

    private class EndpointStateMonitor
    implements Runnable {
        private final ManagedChannel channel;
        private final String endpoint;

        private EndpointStateMonitor(ManagedChannel channel, String endpoint) {
            this.endpoint = endpoint;
            this.channel = channel;
            this.run();
        }

        @Override
        public void run() {
            if (this.channel == null) {
                return;
            }
            ConnectivityState newState = GcpMultiEndpointChannel.this.checkPoolState(this.channel, this.endpoint);
            if (newState != ConnectivityState.SHUTDOWN) {
                this.channel.notifyWhenStateChanged(newState, (Runnable)this);
            }
        }
    }
}

