/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.schema.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.connect.data.Schema;

public class JsonNodeStructValueConvertor {
    private JsonNodeStructValueConvertor() {
    }

    public static ByteBuffer getBytes(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(node.asText().getBytes(StandardCharsets.UTF_8));
        return ByteBuffer.wrap(bytes);
    }

    public static Long getLong(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        return node.asLong();
    }

    public static Double getDouble(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        return node.asDouble();
    }

    public static Boolean getBoolean(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        return node.asBoolean();
    }

    public static String getString(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        return node.asText();
    }

    public static List<Object> getList(JsonNode node, Schema.Type type) {
        if (node.isNull()) {
            return null;
        }
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        return StreamSupport.stream(node.spliterator(), false).map(elNode -> JsonNodeStructValueConvertor.getValueFromNode(elNode, type)).collect(Collectors.toList());
    }

    private static Object getValueFromNode(JsonNode node, Schema.Type type) {
        switch (type) {
            case FLOAT64: {
                return JsonNodeStructValueConvertor.getDouble(node);
            }
            case STRING: {
                return JsonNodeStructValueConvertor.getString(node);
            }
            case INT64: {
                return JsonNodeStructValueConvertor.getLong(node);
            }
            case BOOLEAN: {
                return JsonNodeStructValueConvertor.getBoolean(node);
            }
            case BYTES: {
                return JsonNodeStructValueConvertor.getBytes(node);
            }
        }
        throw new IllegalArgumentException();
    }
}

