/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.BinAcceptor;
import java.util.Iterator;
import java.util.Objects;

public interface IndexMappingConverter {
    public void convertAscendingIterator(Iterator<Bin> var1, BinAcceptor var2);

    public static IndexMappingConverter distributingUniformly(IndexMapping inMapping, IndexMapping outMapping) {
        Objects.requireNonNull(inMapping);
        Objects.requireNonNull(outMapping);
        return (inBins, outBins) -> {
            Integer inIndex = null;
            int outIndex = Integer.MIN_VALUE;
            double value = 0.0;
            double outCount = 0.0;
            while (inBins.hasNext()) {
                Bin inBin = (Bin)inBins.next();
                if (inIndex != null && inBin.getIndex() <= inIndex) {
                    throw new IllegalArgumentException("The bin iterator is not ascending.");
                }
                inIndex = inBin.getIndex();
                double inLowerBound = inMapping.lowerBound(inBin.getIndex());
                double inUpperBound = inMapping.upperBound(inBin.getIndex());
                if (inLowerBound < value) {
                    throw new RuntimeException("The input mapping is invalid.");
                }
                value = inLowerBound;
                int newOutIndex = outMapping.index(value);
                if (newOutIndex < outIndex) {
                    throw new RuntimeException("The output mapping is invalid.");
                }
                if (newOutIndex > outIndex && outCount != 0.0) {
                    outBins.accept(outIndex, outCount);
                    outCount = 0.0;
                }
                outIndex = newOutIndex;
                while (true) {
                    double d;
                    double outUpperBound = outMapping.upperBound(outIndex);
                    if (!(d < inUpperBound)) break;
                    value = outUpperBound;
                    if ((outCount += inBin.getCount() * (outUpperBound - value) / (inUpperBound - inLowerBound)) != 0.0) {
                        outBins.accept(outIndex, outCount);
                        outCount = 0.0;
                    }
                    ++outIndex;
                }
                outCount += inBin.getCount() * (inUpperBound - value) / (inUpperBound - inLowerBound);
            }
            if (outCount != 0.0) {
                outBins.accept(outIndex, outCount);
            }
        };
    }
}

