/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.ChildPartitionOperation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ChildPartitionOperationTest {
    ChildPartitionOperationTest() {
    }

    @Test
    void doOperation() {
        TaskSyncContext taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("n1", "parent0", Set.of("parent0")), this.buildPartition("n2", "parent0", Set.of("parent0")))).doOperation(this.buildTaskSyncContext());
        Assertions.assertEquals((int)3, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)2, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
        taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("n3", "parent0", Set.of("parent0")), this.buildPartition("n4", "parent0", Set.of("parent0")))).doOperation(taskSyncContext);
        Assertions.assertEquals((int)3, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)4, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
        taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("n5", "parent0", Set.of("parent0")))).doOperation(taskSyncContext);
        Assertions.assertEquals((int)4, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)4, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
    }

    @Test
    void doOperationReceiveChildPartitionAfterMergeFromParent2() {
        TaskSyncContext taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("n5", "parent2", Set.of("parent1", "parent2")))).doOperation(this.buildTaskSyncContext2());
        Assertions.assertEquals((int)1, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)0, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
    }

    @Test
    void doOperationReceiveChildPartitionAfterMergeFromParent1() {
        TaskSyncContext taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("n5", "parent1", Set.of("parent1", "parent2")))).doOperation(this.buildTaskSyncContext2());
        Assertions.assertEquals((int)2, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)0, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
    }

    @Test
    void doOperationReceiveChildPartitionAfterMergeFromInitialPartition() {
        TaskSyncContext taskSyncContext = new ChildPartitionOperation(List.of(this.buildPartition("Parent0", null, Set.of()))).doOperation(this.buildEmptyTaskSyncContext());
        Assertions.assertEquals((int)1, (int)taskSyncContext.getCurrentTaskState().getPartitions().size());
        Assertions.assertEquals((int)0, (int)taskSyncContext.getCurrentTaskState().getSharedPartitions().size());
    }

    private TaskSyncContext buildTaskSyncContext() {
        return TaskSyncContext.builder().taskUid("taskO").currentTaskState(TaskState.builder().taskUid("taskO").partitions(List.of(PartitionState.builder().token("t1").state(PartitionStateEnum.RUNNING).build(), PartitionState.builder().token("t2").state(PartitionStateEnum.RUNNING).build(), PartitionState.builder().token("t3").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build()).taskStates(Map.of("task1", TaskState.builder().taskUid("task1").partitions(List.of(PartitionState.builder().token("t6").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build(), "task2", TaskState.builder().taskUid("task2").partitions(List.of(PartitionState.builder().token("t7").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build())).build();
    }

    private TaskSyncContext buildTaskSyncContext2() {
        return TaskSyncContext.builder().taskUid("taskO").currentTaskState(TaskState.builder().taskUid("taskO").partitions(List.of(PartitionState.builder().token("t1").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build()).taskStates(Map.of("task1", TaskState.builder().taskUid("task1").partitions(List.of(PartitionState.builder().token("t6").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build(), "task2", TaskState.builder().taskUid("task2").partitions(List.of(PartitionState.builder().token("t7").state(PartitionStateEnum.RUNNING).build())).sharedPartitions(List.of()).build())).build();
    }

    private TaskSyncContext buildEmptyTaskSyncContext() {
        return TaskSyncContext.builder().taskUid("taskO").currentTaskState(TaskState.builder().taskUid("taskO").partitions(List.of()).sharedPartitions(List.of()).build()).taskStates(Map.of("task1", TaskState.builder().taskUid("task1").partitions(List.of()).sharedPartitions(List.of()).build(), "task2", TaskState.builder().taskUid("task2").partitions(List.of()).sharedPartitions(List.of()).build())).build();
    }

    private Partition buildPartition(String token, String originParent, Set<String> parents) {
        return Partition.builder().token(token).parentTokens(parents).startTimestamp(Timestamp.now()).endTimestamp(null).originPartitionToken(originParent).build();
    }
}

