/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.metadata;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ForwardingAsyncResultSet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import io.debezium.connector.spanner.db.dao.SchemaDao;
import io.debezium.connector.spanner.db.metadata.SchemaRegistry;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.schema.Column;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SchemaRegistryTest {
    SchemaRegistryTest() {
    }

    @Test
    void testInit() throws SpannerException {
        AsyncResultSet asyncResultSet = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        Mockito.when((Object)asyncResultSet.getBoolean(Mockito.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)asyncResultSet.getString(Mockito.anyInt())).thenReturn((Object)"String");
        Mockito.when((Object)asyncResultSet.next()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        ReadOnlyTransaction readOnlyTransaction = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)readOnlyTransaction.executeQuery((Statement)Mockito.any(), (Options.QueryOption[])Mockito.any())).thenReturn((Object)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet(asyncResultSet))))));
        ((ReadOnlyTransaction)Mockito.doNothing().when((Object)readOnlyTransaction)).close();
        DatabaseClient databaseClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)databaseClient.readOnlyTransaction((TimestampBound)Mockito.any())).thenReturn((Object)readOnlyTransaction);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao(databaseClient), (Runnable)Mockito.mock(Runnable.class));
        schemaRegistry.init("taskUid");
        ((DatabaseClient)Mockito.verify((Object)databaseClient, (VerificationMode)Mockito.atLeast((int)1))).readOnlyTransaction((TimestampBound)Mockito.any());
        ((ReadOnlyTransaction)Mockito.verify((Object)readOnlyTransaction, (VerificationMode)Mockito.atLeast((int)1))).executeQuery((Statement)Mockito.any(), (Options.QueryOption[])Mockito.any());
        ((ReadOnlyTransaction)Mockito.verify((Object)readOnlyTransaction, (VerificationMode)Mockito.atLeast((int)1))).close();
        ((AsyncResultSet)Mockito.verify((Object)asyncResultSet, (VerificationMode)Mockito.atLeast((int)1))).next();
        ((AsyncResultSet)Mockito.verify((Object)asyncResultSet, (VerificationMode)Mockito.atLeast((int)1))).getBoolean(Mockito.anyInt());
        Assertions.assertTrue((boolean)schemaRegistry.getAllTables().isEmpty());
    }

    @Test
    void testGetWatchedTable() {
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class));
        Assertions.assertThrows(IllegalStateException.class, () -> schemaRegistry.getWatchedTable(TableId.getTableId((String)"Table Name")));
    }

    @Test
    void testGetAllTables() {
        Assertions.assertThrows(IllegalStateException.class, () -> new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class)).getAllTables());
    }

    @Test
    void testCheckSchema() {
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao((DatabaseClient)Mockito.mock(DatabaseClient.class)), (Runnable)Mockito.mock(Runnable.class));
        TableId tableId = TableId.getTableId((String)"Table Name");
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Assertions.assertThrows(IllegalStateException.class, () -> schemaRegistry.checkSchema(tableId, timestamp, new ArrayList()));
    }

    @Test
    void testUpdateAndPublish() throws SpannerException {
        AsyncResultSet asyncResultSet = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        Mockito.when((Object)asyncResultSet.getBoolean(Mockito.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)asyncResultSet.getString(Mockito.anyInt())).thenReturn((Object)"String");
        Mockito.when((Object)asyncResultSet.next()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        ReadOnlyTransaction readOnlyTransaction = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)readOnlyTransaction.executeQuery((Statement)Mockito.any(), (Options.QueryOption[])Mockito.any())).thenReturn((Object)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet(asyncResultSet))))));
        ((ReadOnlyTransaction)Mockito.doNothing().when((Object)readOnlyTransaction)).close();
        DatabaseClient databaseClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)databaseClient.readOnlyTransaction((TimestampBound)Mockito.any())).thenReturn((Object)readOnlyTransaction);
        SchemaDao schemaDao = new SchemaDao(databaseClient);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", schemaDao, (Runnable)Mockito.mock(Runnable.class));
        schemaRegistry.updateSchema(TableId.getTableId((String)"Name"), Timestamp.ofTimeMicroseconds((long)1L), new ArrayList());
        ((DatabaseClient)Mockito.verify((Object)databaseClient, (VerificationMode)Mockito.atLeast((int)1))).readOnlyTransaction((TimestampBound)Mockito.any());
        ((ReadOnlyTransaction)Mockito.verify((Object)readOnlyTransaction, (VerificationMode)Mockito.atLeast((int)1))).executeQuery((Statement)Mockito.any(), (Options.QueryOption[])Mockito.any());
        ((ReadOnlyTransaction)Mockito.verify((Object)readOnlyTransaction, (VerificationMode)Mockito.atLeast((int)1))).close();
        ((AsyncResultSet)Mockito.verify((Object)asyncResultSet, (VerificationMode)Mockito.atLeast((int)1))).next();
        ((AsyncResultSet)Mockito.verify((Object)asyncResultSet, (VerificationMode)Mockito.atLeast((int)1))).getBoolean(Mockito.anyInt());
        Assertions.assertTrue((boolean)schemaRegistry.getAllTables().isEmpty());
    }

    @Test
    void testUpdateSchema() throws SpannerException {
        AsyncResultSet asyncResultSet = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        Mockito.when((Object)asyncResultSet.getBoolean(Mockito.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)asyncResultSet.getString(Mockito.anyInt())).thenReturn((Object)"String");
        Mockito.when((Object)asyncResultSet.next()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        ReadOnlyTransaction readOnlyTransaction = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)readOnlyTransaction.executeQuery((Statement)Mockito.any(), (Options.QueryOption[])Mockito.any())).thenReturn((Object)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet((AsyncResultSet)new ForwardingAsyncResultSet(asyncResultSet))))));
        ((ReadOnlyTransaction)Mockito.doNothing().when((Object)readOnlyTransaction)).close();
        DatabaseClient databaseClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)databaseClient.readOnlyTransaction((TimestampBound)Mockito.any())).thenReturn((Object)readOnlyTransaction);
        SchemaRegistry schemaRegistry = new SchemaRegistry("Stream Name", new SchemaDao(databaseClient), (Runnable)Mockito.mock(Runnable.class));
        Assertions.assertTrue((boolean)schemaRegistry.updateSchema(TableId.getTableId((String)"Name"), Timestamp.ofTimeMicroseconds((long)1L), new ArrayList()));
        ((DatabaseClient)Mockito.verify((Object)databaseClient, (VerificationMode)Mockito.atLeast((int)1))).readOnlyTransaction((TimestampBound)Mockito.any());
        ((ReadOnlyTransaction)Mockito.verify((Object)readOnlyTransaction, (VerificationMode)Mockito.atLeast((int)1))).executeQuery((Statement)Mockito.any(), (Options.QueryOption[])Mockito.any());
        ((ReadOnlyTransaction)Mockito.verify((Object)readOnlyTransaction, (VerificationMode)Mockito.atLeast((int)1))).close();
        ((AsyncResultSet)Mockito.verify((Object)asyncResultSet, (VerificationMode)Mockito.atLeast((int)1))).next();
        ((AsyncResultSet)Mockito.verify((Object)asyncResultSet, (VerificationMode)Mockito.atLeast((int)1))).getBoolean(Mockito.anyInt());
        Assertions.assertTrue((boolean)schemaRegistry.getAllTables().isEmpty());
    }

    @Test
    void testUpdateSchemaFromStaleTimeStampFromCheckSchema() {
        SchemaDao schemaDao = (SchemaDao)Mockito.mock(SchemaDao.class);
        SchemaRegistry schemaRegistry = (SchemaRegistry)Mockito.spy((Object)new SchemaRegistry("Stream Name", schemaDao, (Runnable)Mockito.mock(Runnable.class)));
        TableId tableId = TableId.getTableId((String)"Name");
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)1L);
        ArrayList<Column> rowType = new ArrayList<Column>();
        rowType.add(Column.create((String)"name1", (String)"BOOL", (boolean)true, (long)1L, (boolean)false, (Dialect)Dialect.GOOGLE_STANDARD_SQL));
        rowType.add(Column.create((String)"name2", (String)"STRING", (boolean)false, (long)1L, (boolean)false, (Dialect)Dialect.GOOGLE_STANDARD_SQL));
        Mockito.when((Object)schemaDao.isPostgres()).thenReturn((Object)false);
        schemaRegistry.updateSchemaFromStaleTimestamp(tableId, timestamp, rowType);
        Assertions.assertEquals((int)1, (int)schemaRegistry.getAllTables().size());
        Assertions.assertEquals((Object)"Name", (Object)((TableId)schemaRegistry.getAllTables().iterator().next()).getTableName());
    }
}

