/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc.multiendpoint;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.concurrent.ScheduledFuture;

@CheckReturnValue
final class Endpoint {
    private final String id;
    private EndpointState state;
    private int priority;
    private ScheduledFuture<?> changeStateFuture;

    public Endpoint(String id, EndpointState state, int priority) {
        this.id = id;
        this.priority = priority;
        this.state = state;
    }

    public String getId() {
        return this.id;
    }

    public EndpointState getState() {
        return this.state;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setState(EndpointState state) {
        this.state = state;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public synchronized void setChangeStateFuture(ScheduledFuture<?> future) {
        this.resetStateChangeFuture();
        this.changeStateFuture = future;
    }

    public synchronized void resetStateChangeFuture() {
        if (this.changeStateFuture != null) {
            this.changeStateFuture.cancel(true);
        }
    }

    public static enum EndpointState {
        UNAVAILABLE,
        AVAILABLE,
        RECOVERING;

    }
}

