/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.schema;

import io.debezium.connector.spanner.db.metadata.SchemaRegistry;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.schema.TableSchema;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchema;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class KafkaSpannerSchemaTest {
    KafkaSpannerSchemaTest() {
    }

    @Test
    void getSchema() {
        TableId testTableId = TableId.getTableId((String)"test");
        TopicNamingStrategy topicNamingStrategy = (TopicNamingStrategy)Mockito.mock(TopicNamingStrategy.class);
        Mockito.when((Object)topicNamingStrategy.dataChangeTopic((DataCollectionId)testTableId)).thenReturn((Object)"test.Value");
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust("test.Value")).thenReturn((Object)"adjust_test.Value");
        Mockito.when((Object)schemaNameAdjuster.adjust("test.Value.Envelope")).thenReturn((Object)"adjust_test.Value.Envelope");
        SchemaRegistry schemaRegistry = (SchemaRegistry)Mockito.mock(SchemaRegistry.class);
        Mockito.when((Object)schemaRegistry.getWatchedTable(testTableId)).thenReturn((Object)new TableSchema(testTableId.getTableName(), List.of()));
        Schema sourceInfoSchema = Schema.OPTIONAL_STRING_SCHEMA;
        KafkaSpannerTableSchemaFactory kafkaSpannerTableSchemaFactory = new KafkaSpannerTableSchemaFactory(topicNamingStrategy, schemaNameAdjuster, schemaRegistry, sourceInfoSchema);
        KafkaSpannerTableSchema tableSchema = kafkaSpannerTableSchemaFactory.getTableSchema(testTableId);
        Assertions.assertEquals((Object)"adjust_test.Value.Envelope", (Object)tableSchema.getEnvelopeSchema().schema().name());
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)tableSchema.getEnvelopeSchema().schema().type());
        Assertions.assertLinesMatch(List.of("before", "after", "source", "op", "ts_ms", "transaction"), tableSchema.getEnvelopeSchema().schema().fields().stream().map(Field::name).collect(Collectors.toList()));
        Assertions.assertEquals((Object)testTableId, (Object)tableSchema.id());
        Assertions.assertNull((Object)tableSchema.keySchema());
        Assertions.assertEquals((Object)"adjust_test.Value", (Object)tableSchema.valueSchema().name());
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)tableSchema.valueSchema().type());
    }
}

