/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.stream;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import io.debezium.connector.spanner.db.dao.ChangeStreamDao;
import io.debezium.connector.spanner.db.dao.ChangeStreamResultSet;
import io.debezium.connector.spanner.db.mapper.ChangeStreamRecordMapper;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.db.model.event.ChangeStreamEvent;
import io.debezium.connector.spanner.db.stream.ChangeStreamEventConsumer;
import io.debezium.connector.spanner.db.stream.PartitionEventListener;
import io.debezium.connector.spanner.db.stream.SpannerChangeStreamService;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import java.time.Duration;
import java.util.HashSet;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SpannerChangeStreamServiceTest {
    SpannerChangeStreamServiceTest() {
    }

    @Test
    void testGetEvents() throws InterruptedException, Exception {
        ChangeStreamDao changeStreamDao = (ChangeStreamDao)Mockito.mock(ChangeStreamDao.class);
        ChangeStreamResultSet changeStreamResultSet = (ChangeStreamResultSet)Mockito.mock(ChangeStreamResultSet.class);
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.mock(MetricsEventPublisher.class);
        Mockito.when((Object)changeStreamResultSet.next()).thenReturn((Object)false);
        Mockito.when((Object)changeStreamDao.streamQuery((String)Mockito.any(), (Timestamp)Mockito.any(), (Timestamp)Mockito.any(), ArgumentMatchers.anyLong())).thenReturn((Object)changeStreamResultSet);
        DatabaseClient gsqlDatabaseClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)gsqlDatabaseClient.getDialect()).thenReturn((Object)Dialect.GOOGLE_STANDARD_SQL);
        SpannerChangeStreamService spannerChangeStreamService = new SpannerChangeStreamService("TaskUid", changeStreamDao, new ChangeStreamRecordMapper(gsqlDatabaseClient), Duration.ofMillis(1000L), metricsEventPublisher);
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Partition partition = new Partition("token", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L), "originParent");
        ChangeStreamEventConsumer changeStreamEventConsumer = (ChangeStreamEventConsumer)Mockito.mock(ChangeStreamEventConsumer.class);
        PartitionEventListener partitionEventListener = (PartitionEventListener)Mockito.mock(PartitionEventListener.class);
        ((PartitionEventListener)Mockito.doNothing().when((Object)partitionEventListener)).onRun((Partition)Mockito.any());
        spannerChangeStreamService.getEvents(partition, changeStreamEventConsumer, partitionEventListener);
        ((ChangeStreamEventConsumer)Mockito.verify((Object)changeStreamEventConsumer)).acceptChangeStreamEvent((ChangeStreamEvent)Mockito.any());
    }
}

