/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.Serializer;
import com.datadoghq.sketch.ddsketch.encoding.IndexMappingLayout;
import com.datadoghq.sketch.ddsketch.encoding.Output;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import com.datadoghq.sketch.ddsketch.mapping.Interpolation;
import java.io.IOException;
import java.util.Objects;

abstract class LogLikeIndexMapping
implements IndexMapping {
    private final double gamma;
    private final double indexOffset;
    private final double relativeAccuracy;
    private final double multiplier;

    LogLikeIndexMapping(double gamma, double indexOffset) {
        this.gamma = LogLikeIndexMapping.requireValidGamma(gamma);
        this.indexOffset = indexOffset;
        this.multiplier = Math.log(this.base()) / Math.log1p(gamma - 1.0);
        this.relativeAccuracy = LogLikeIndexMapping.relativeAccuracy(gamma, this.correctingFactor());
    }

    private static double relativeAccuracy(double gamma, double correctingFactor) {
        double exactLogGamma = Math.pow(gamma, correctingFactor);
        return (exactLogGamma - 1.0) / (exactLogGamma + 1.0);
    }

    static double gamma(double relativeAccuracy, double correctingFactor) {
        double exactLogGamma = (1.0 + relativeAccuracy) / (1.0 - relativeAccuracy);
        return Math.pow(exactLogGamma, 1.0 / correctingFactor);
    }

    static double requireValidRelativeAccuracy(double relativeAccuracy) {
        if (relativeAccuracy <= 0.0 || relativeAccuracy >= 1.0) {
            throw new IllegalArgumentException("The relative accuracy must be between 0 and 1.");
        }
        return relativeAccuracy;
    }

    private static double requireValidGamma(double gamma) {
        if (gamma <= 1.0) {
            throw new IllegalArgumentException("gamma must be greater than 1.");
        }
        return gamma;
    }

    abstract double log(double var1);

    abstract double logInverse(double var1);

    abstract double base();

    abstract double correctingFactor();

    @Override
    public final int index(double value) {
        double index = this.log(value) * this.multiplier + this.indexOffset;
        return index >= 0.0 ? (int)index : (int)index - 1;
    }

    @Override
    public final double value(int index) {
        return this.lowerBound(index) * (1.0 + this.relativeAccuracy);
    }

    @Override
    public double lowerBound(int index) {
        return this.logInverse(((double)index - this.indexOffset) / this.multiplier);
    }

    @Override
    public double upperBound(int index) {
        return this.lowerBound(index + 1);
    }

    @Override
    public final double relativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double minIndexableValue() {
        return Math.max(Math.pow(this.base(), (-2.147483648E9 - this.indexOffset) / this.multiplier + 1.0), Double.MIN_NORMAL * (1.0 + this.relativeAccuracy) / (1.0 - this.relativeAccuracy));
    }

    @Override
    public double maxIndexableValue() {
        return Math.min(Math.pow(this.base(), (2.147483647E9 - this.indexOffset) / this.multiplier - 1.0), Double.MAX_VALUE / (1.0 + this.relativeAccuracy));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogLikeIndexMapping that = (LogLikeIndexMapping)o;
        return Double.compare(that.gamma, this.gamma) == 0 && Double.compare(that.indexOffset, this.indexOffset) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.gamma, this.indexOffset);
    }

    abstract IndexMappingLayout layout();

    @Override
    public void encode(Output output) throws IOException {
        this.layout().toFlag().encode(output);
        output.writeDoubleLE(this.gamma);
        output.writeDoubleLE(this.indexOffset);
    }

    abstract Interpolation interpolation();

    @Override
    public int serializedSize() {
        return Serializer.doubleFieldSize(1, this.gamma) + Serializer.doubleFieldSize(2, this.indexOffset) + Serializer.fieldSize(3, this.interpolation().ordinal());
    }

    @Override
    public void serialize(Serializer serializer) {
        serializer.writeDouble(1, this.gamma);
        serializer.writeDouble(2, this.indexOffset);
        serializer.writeUnsignedInt32(3, this.interpolation().ordinal());
    }

    double gamma() {
        return this.gamma;
    }

    double indexOffset() {
        return this.indexOffset;
    }
}

