/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class AsyncRunnerImpl
implements AsyncRunner {
    private final TransactionRunnerImpl delegate;
    private SettableApiFuture<CommitResponse> commitResponse;

    AsyncRunnerImpl(TransactionRunnerImpl delegate) {
        this.delegate = (TransactionRunnerImpl)Preconditions.checkNotNull((Object)delegate);
    }

    @Override
    public <R> ApiFuture<R> runAsync(AsyncRunner.AsyncWork<R> work, Executor executor) {
        Preconditions.checkState((this.commitResponse == null ? 1 : 0) != 0, (Object)"runAsync() can only be called once");
        this.commitResponse = SettableApiFuture.create();
        SettableApiFuture res = SettableApiFuture.create();
        executor.execute(() -> {
            try {
                res.set(this.runTransaction(work));
            }
            catch (Throwable t) {
                res.setException(t);
            }
            finally {
                this.setCommitResponse();
            }
        });
        return res;
    }

    private <R> R runTransaction(AsyncRunner.AsyncWork<R> work) {
        return (R)this.delegate.run(transaction -> {
            try {
                return work.doWorkAsync(transaction).get();
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause());
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        });
    }

    private void setCommitResponse() {
        try {
            this.commitResponse.set((Object)this.delegate.getCommitResponse());
        }
        catch (Throwable t) {
            this.commitResponse.setException(t);
        }
    }

    @Override
    public ApiFuture<Timestamp> getCommitTimestamp() {
        Preconditions.checkState((this.commitResponse != null ? 1 : 0) != 0, (Object)"runAsync() has not yet been called");
        return ApiFutures.transform(this.commitResponse, CommitResponse::getCommitTimestamp, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<CommitResponse> getCommitResponse() {
        Preconditions.checkState((this.commitResponse != null ? 1 : 0) != 0, (Object)"runAsync() has not yet been called");
        return this.commitResponse;
    }
}

