/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.leader.rebalancer;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.leader.rebalancer.TaskPartitionRebalancer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPartitionEqualSharingRebalancer
implements TaskPartitionRebalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskPartitionEqualSharingRebalancer.class);

    @Override
    public TaskState rebalance(TaskState leaderTaskState, Map<String, TaskState> survivedTasks, Map<String, TaskState> obsoleteTaskStates) {
        LOGGER.info("Leader task state {}", (Object)leaderTaskState.getTaskUid());
        LOGGER.info("Survived tasks {}", survivedTasks.keySet().stream().collect(Collectors.toList()));
        LOGGER.info("Obsolete tasks {}", obsoleteTaskStates.keySet().stream().collect(Collectors.toList()));
        TaskState newLeaderTaskState = this.moveFinishedPartitionsFromObsoleteTasks(leaderTaskState, obsoleteTaskStates);
        LOGGER.debug("Leader task state after moving finished partitions from obsolete tasks {}", (Object)newLeaderTaskState);
        newLeaderTaskState = this.moveSharedPartitionsFromObsoleteTasks(newLeaderTaskState, survivedTasks, obsoleteTaskStates);
        LOGGER.debug("Leader task state after moving finished partitions from obsolete tasks {}", (Object)newLeaderTaskState);
        newLeaderTaskState = this.takeSharedPartitionsFromSurvivedTasks(newLeaderTaskState, survivedTasks);
        LOGGER.debug("Leader task state after moving shared partitions from survived tasks {}", (Object)newLeaderTaskState);
        newLeaderTaskState = this.takeSharedPartitionsToObsoleteTask(newLeaderTaskState, survivedTasks);
        LOGGER.debug("Leader task state after moving shared partitions to obsolete tasks {}", (Object)newLeaderTaskState);
        newLeaderTaskState = this.distributePartitionsFromObsoleteTasks(newLeaderTaskState, survivedTasks, obsoleteTaskStates);
        LOGGER.debug("Leader task state after distributing partitions from obsolete tasks {}", (Object)newLeaderTaskState);
        return newLeaderTaskState;
    }

    private TaskState moveFinishedPartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> obsoleteTasks) {
        Set<String> tokens = this.collectPartitionTokens(Set.of(leaderTaskState));
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List<PartitionState> allPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        List finishedPartitions = allPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).map(partitionState -> {
            if (PartitionStateEnum.FINISHED.equals((Object)partitionState.getState())) {
                return partitionState.toBuilder().assigneeTaskUid(leaderTaskState.getTaskUid()).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        leaderPartitionList.addAll(finishedPartitions);
        LOGGER.info("moveFinishedPartitionsFromObsoleteTasks, Leader task {} owning finished partitions {}", (Object)leaderTaskState.getTaskUid(), finishedPartitions);
        return leaderTaskState.toBuilder().partitions(leaderPartitionList).build();
    }

    private TaskState distributePartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> survivedTasks, Map<String, TaskState> obsoleteTasks) {
        Set<String> tokens = this.collectPartitionTokens(Set.of(leaderTaskState), survivedTasks.values());
        List<PartitionState> allPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        List notFinishedPartitions = allPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).map(partitionState -> {
            if (!PartitionStateEnum.FINISHED.equals((Object)partitionState.getState()) && !PartitionStateEnum.REMOVED.equals((Object)partitionState.getState())) {
                return partitionState;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        ArrayList<PartitionState> leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
        for (PartitionState partitionState2 : notFinishedPartitions) {
            String taskUid = this.findCandidateToSharePartition(leaderTaskState, survivedTasks);
            if (!taskUid.equals(leaderTaskState.getTaskUid())) {
                leaderSharedPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            } else {
                leaderPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            }
            leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        }
        LOGGER.info("distributePartitionsFromObsoleteTasks, Leader task {} now owning partitios {}", (Object)leaderTaskState.getTaskUid(), leaderPartitionList);
        LOGGER.info("distributePartitionsFromObsoleteTasks, Leader task {} now sharing partitions {}", (Object)leaderTaskState.getTaskUid(), leaderSharedPartitionList);
        return leaderTaskState;
    }

    private String findCandidateToSharePartition(TaskState leaderTaskState, Map<String, TaskState> survivedTasks) {
        HashMap<String, TaskState> allTaskStates = new HashMap<String, TaskState>(survivedTasks);
        allTaskStates.put(leaderTaskState.getTaskUid(), leaderTaskState);
        Map<String, Integer> candidateMap = allTaskStates.values().stream().map(taskState -> {
            Set tokens = taskState.getPartitions().stream().filter(partitionState -> !PartitionStateEnum.FINISHED.equals((Object)partitionState.getState()) && !PartitionStateEnum.REMOVED.equals((Object)partitionState.getState())).map(PartitionState::getToken).collect(Collectors.toCollection(HashSet::new));
            Set assignedTokens = allTaskStates.values().stream().flatMap(taskState1 -> taskState1.getSharedPartitions().stream()).filter(partitionState -> partitionState.getAssigneeTaskUid().equals(taskState.getTaskUid())).map(PartitionState::getToken).collect(Collectors.toSet());
            tokens.addAll(assignedTokens);
            return new AbstractMap.SimpleEntry<String, Integer>(taskState.getTaskUid(), tokens.size());
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        Optional<Integer> minPartitionsValue = candidateMap.values().stream().min(Integer::compare);
        if (minPartitionsValue.isEmpty()) {
            return leaderTaskState.getTaskUid();
        }
        List finalCandidateList = candidateMap.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(minPartitionsValue.get())).map(Map.Entry::getKey).collect(Collectors.toList());
        int index = new Random().nextInt(finalCandidateList.size());
        return (String)finalCandidateList.get(index);
    }

    private TaskState moveSharedPartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> survivedTasks, Map<String, TaskState> obsoleteTasks) {
        Set<String> leaderTokens = this.collectPartitionTokens(Set.of(leaderTaskState));
        Set<String> survivedOwnedTokens = this.collectOwnedPartitionTokens(survivedTasks.values());
        String leaderUid = leaderTaskState.getTaskUid();
        List<PartitionState> obsoleteTasksSharedPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toList()));
        ArrayList<PartitionState> leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List newSharedPartitions = obsoleteTasksSharedPartitions.stream().filter(partitionState -> !leaderTokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).map(partitionState -> {
            if (survivedTasks.containsKey(partitionState.getAssigneeTaskUid())) {
                return partitionState;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        LOGGER.info("moveSharedPartitionsFromObsoleteTasks, Leader task {} now sharing partitions {}", (Object)leaderTaskState.getTaskUid(), newSharedPartitions);
        leaderSharedPartitionList.addAll(newSharedPartitions);
        List newOwnedPartitions = obsoleteTasksSharedPartitions.stream().filter(partitionState -> !leaderTokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).map(partitionState -> {
            if (leaderUid.equals(partitionState.getAssigneeTaskUid())) {
                return partitionState;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        leaderPartitionList.addAll(newOwnedPartitions);
        LOGGER.info("moveSharedPartitionsFromObsoleteTasks, Leader task {} now owning partitions {}", (Object)leaderTaskState.getTaskUid(), newOwnedPartitions);
        leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        Set<String> tokensSharedToSurvivedTasks = this.collectTokensSharedToSurvivedTasks(leaderTaskState, survivedTasks.values());
        Set<String> newLeaderTokens = this.collectPartitionTokens(Set.of(leaderTaskState));
        leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
        leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List newPartitions = obsoleteTasksSharedPartitions.stream().filter(partitionState -> !newLeaderTokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).filter(partitionState -> !tokensSharedToSurvivedTasks.contains(partitionState.getToken())).collect(Collectors.toList());
        for (PartitionState partitionState2 : newPartitions) {
            String taskUid = this.findCandidateToSharePartition(leaderTaskState, survivedTasks);
            if (!taskUid.equals(leaderTaskState.getTaskUid())) {
                leaderSharedPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            } else {
                leaderPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            }
            leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        }
        LOGGER.info("moveSharedPartitionsFromObsoleteTasks, Leader task {} now sharing partitions {}", (Object)leaderTaskState.getTaskUid(), leaderPartitionList);
        LOGGER.info("moveSharedPartitionsFromObsoleteTasks, Leader task {} now owning partitions {}", (Object)leaderTaskState.getTaskUid(), leaderSharedPartitionList);
        return leaderTaskState;
    }

    private TaskState takeSharedPartitionsFromSurvivedTasks(TaskState leaderTaskState, Map<String, TaskState> survivedTasks) {
        Set<String> tokens = this.collectPartitionTokens(Set.of(leaderTaskState));
        Set<String> survivedOwnedTokens = this.collectOwnedPartitionTokens(survivedTasks.values());
        Set<String> tokensSharedToSurvivedTasks = this.collectTokensSharedToSurvivedTasks(leaderTaskState, survivedTasks.values());
        String leaderUid = leaderTaskState.getTaskUid();
        List partitions = this.filterDuplications(survivedTasks.values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toList())).stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).filter(partitionState -> !tokensSharedToSurvivedTasks.contains(partitionState.getToken())).collect(Collectors.toList());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        ArrayList<PartitionState> leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
        for (PartitionState partitionState2 : partitions) {
            String taskUid = this.findCandidateToSharePartition(leaderTaskState, survivedTasks);
            if (!taskUid.equals(leaderUid)) {
                leaderSharedPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            } else {
                leaderPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            }
            leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        }
        LOGGER.info("takeSharedPartitionsFromSurvivedTasks, Leader task {} now sharing partition {}", (Object)leaderTaskState.getTaskUid(), leaderSharedPartitionList);
        LOGGER.info("takeSharedPartitionsFromSurvivedTasks, Leader task {} now owning partition {}", (Object)leaderTaskState.getTaskUid(), leaderPartitionList);
        return leaderTaskState;
    }

    private TaskState takeSharedPartitionsToObsoleteTask(TaskState leaderTaskState, Map<String, TaskState> survivedTasks) {
        Set<String> tokens = leaderTaskState.getPartitionsMap().keySet();
        Set<String> survivedOwnedTokens = this.collectOwnedPartitionTokens(survivedTasks.values());
        Set<String> tokensSharedToSurvivedTasks = this.collectTokensSharedToSurvivedTasks(leaderTaskState, survivedTasks.values());
        String leaderUid = leaderTaskState.getTaskUid();
        List partitions = leaderTaskState.getSharedPartitions().stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).filter(partitionState -> !tokensSharedToSurvivedTasks.contains(partitionState.getToken())).collect(Collectors.toList());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List<PartitionState> leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
        leaderSharedPartitionList.removeAll(partitions);
        for (PartitionState partitionState2 : partitions) {
            String taskUid = this.findCandidateToSharePartition(leaderTaskState, survivedTasks);
            if (!taskUid.equals(leaderUid)) {
                leaderSharedPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            } else {
                leaderPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            }
            leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        }
        LOGGER.info("takeSharedPartitionsToObsoleteTask, Leader task {} now owning partitions {}", (Object)leaderTaskState.getTaskUid(), leaderPartitionList);
        LOGGER.info("takeSharedPartitionsToObsoleteTask, Leader task {} now owning partitions {}", (Object)leaderTaskState.getTaskUid(), leaderSharedPartitionList);
        Map<String, PartitionState> ownedPartitions = leaderTaskState.getPartitionsMap();
        leaderSharedPartitionList = leaderTaskState.getSharedPartitions().stream().filter(partitionState -> !ownedPartitions.containsKey(partitionState.getToken())).collect(Collectors.toList());
        return leaderTaskState.toBuilder().sharedPartitions(leaderSharedPartitionList).build();
    }

    private List<PartitionState> filterDuplications(List<PartitionState> partitionStates) {
        return partitionStates.stream().collect(Collectors.groupingBy(PartitionState::getToken)).values().stream().flatMap(list -> list.stream().sorted().limit(1L)).collect(Collectors.toList());
    }

    private Set<String> collectPartitionTokens(Collection<TaskState> ... taskStates) {
        return Arrays.stream(taskStates).flatMap(Collection::stream).flatMap(taskState -> Stream.concat(taskState.getPartitionsMap().keySet().stream(), taskState.getSharedPartitionsMap().keySet().stream())).collect(Collectors.toSet());
    }

    private Set<String> collectOwnedPartitionTokens(Collection<TaskState> ... taskStates) {
        return Arrays.stream(taskStates).flatMap(Collection::stream).flatMap(taskState -> taskState.getPartitionsMap().keySet().stream()).collect(Collectors.toSet());
    }

    private Set<String> collectTokensSharedToSurvivedTasks(TaskState leaderTaskState, Collection<TaskState> ... survivedTasks) {
        HashSet<TaskState> allSurvivedTasks = new HashSet<TaskState>();
        allSurvivedTasks.addAll(Arrays.stream(survivedTasks).flatMap(Collection::stream).collect(Collectors.toSet()));
        allSurvivedTasks.add(leaderTaskState);
        Set allSurvivedTaskUids = allSurvivedTasks.stream().map(taskState -> taskState.getTaskUid()).collect(Collectors.toSet());
        return allSurvivedTasks.stream().flatMap(taskState -> taskState.getSharedPartitionsMap().values().stream()).filter(partition -> allSurvivedTaskUids.contains(partition.getAssigneeTaskUid())).map(partition -> partition.getToken()).collect(Collectors.toSet());
    }
}

