/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.schema.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.connector.spanner.schema.mapper.JsonNodeStructValueConvertor;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonNodeStructValueConvertorTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    JsonNodeStructValueConvertorTest() {
    }

    @Test
    void getBytes() throws JsonProcessingException {
        Assertions.assertEquals((Object)ByteBuffer.wrap(Base64.getDecoder().decode("test".getBytes(StandardCharsets.UTF_8))), (Object)JsonNodeStructValueConvertor.getBytes((JsonNode)OBJECT_MAPPER.readTree("{\"value\": \"test\" }").get("value")));
    }

    @Test
    void getLong() throws JsonProcessingException {
        Assertions.assertEquals((long)10L, (Long)JsonNodeStructValueConvertor.getLong((JsonNode)OBJECT_MAPPER.readTree("{\"value\": 10 }").get("value")));
    }

    @Test
    void getDouble() throws JsonProcessingException {
        Assertions.assertEquals((double)1.123, (Double)JsonNodeStructValueConvertor.getDouble((JsonNode)OBJECT_MAPPER.readTree("{\"value\": 1.123 }").get("value")));
    }

    @Test
    void getBoolean() throws JsonProcessingException {
        Assertions.assertEquals((Object)true, (Object)JsonNodeStructValueConvertor.getBoolean((JsonNode)OBJECT_MAPPER.readTree("{\"value\": true }").get("value")));
    }

    @Test
    void getString() throws JsonProcessingException {
        Assertions.assertEquals((Object)"test_string", (Object)JsonNodeStructValueConvertor.getString((JsonNode)OBJECT_MAPPER.readTree("{\"value\": \"test_string\" }").get("value")));
    }

    @Test
    void getList() throws JsonProcessingException {
        Assertions.assertEquals(List.of(Double.valueOf(1.1), Double.valueOf(2.0), Double.valueOf(3.4)), (Object)JsonNodeStructValueConvertor.getList((JsonNode)OBJECT_MAPPER.readTree("{\"value\": [1.1, 2, 3.4] }").get("value"), (Schema.Type)Schema.Type.FLOAT64));
    }
}

