/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.testcontainers.containers.ContainerState;

public class KafkaBrokerApi<K, V> {
    protected static final String SCHEMA_REGISTRY_PORT = "8081";
    protected static final String SCHEMA_REGISTRY_HOST = "http://localhost";
    protected static final int POLL_DURATION_MILLIS = 100;
    protected static final int WAIT_TOPIC_HAS_NO_MORE_RECORDS_SECONDS = 60;
    public static final int POLL_FIRST_RECORDS_TIMEOUT_MAX_MINUTES = 10;
    private final ContainerState containerState;
    private final int kafkaPort;
    private final Properties properties;

    public KafkaBrokerApi(ContainerState containerState, int kafkaPort, Properties properties) {
        this.containerState = containerState;
        this.kafkaPort = kafkaPort;
        this.properties = (Properties)SerializationUtils.clone((Serializable)properties);
    }

    public static String getSchemaRegistryAddress() {
        return "http://localhost:8081";
    }

    public static KafkaBrokerApi<ObjectNode, ObjectNode> createKafkaBrokerApiObjectNode(ContainerState containerState, int kafkaPort) {
        Properties props = new Properties();
        props.put("bootstrap.servers", containerState.getHost() + ":" + kafkaPort);
        props.put("auto.offset.reset", "earliest");
        return new KafkaBrokerApi<ObjectNode, ObjectNode>(containerState, kafkaPort, props);
    }

    public String getAddress() {
        return this.containerState.getHost() + ":" + this.kafkaPort;
    }

    public AdminClient createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.getAddress());
        return AdminClient.create((Properties)props);
    }
}

