/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.scaler;

import io.debezium.connector.spanner.task.scaler.TaskScaleCalculator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskScaleCalculatorTest {
    TaskScaleCalculatorTest() {
    }

    @Test
    void newTasksCount_setInitialTasksCountEqualsToTasksMinTest() {
        int tasksMin = 2;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)0, (int)2, (int)20, (int)2, (long)0L, (long)0L);
        Assertions.assertThat((int)newTasksCount).isEqualTo(tasksMin);
    }

    @Test
    void newTasksCount_initialScaleOutTest() {
        int partitionsInWorkCount = 10;
        int desiredPartitionsTasks = 2;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)0, (int)desiredPartitionsTasks, (int)20, (int)2, (long)partitionsInWorkCount, (long)0L);
        Assertions.assertThat((int)newTasksCount).isEqualTo(partitionsInWorkCount / desiredPartitionsTasks);
    }

    @Test
    void newTasksCount_noScaleRequiredTest() {
        int currentTasksCount = 5;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)currentTasksCount, (int)2, (int)20, (int)2, (long)10L, (long)0L);
        Assertions.assertThat((int)newTasksCount).isEqualTo(currentTasksCount);
    }

    @Test
    void newTasksCount_scaleOutTest() {
        int currentTasksCount = 5;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)currentTasksCount, (int)2, (int)20, (int)2, (long)11L, (long)0L);
        Assertions.assertThat((int)newTasksCount).isGreaterThan(currentTasksCount);
    }

    @Test
    void newTasksCount_scaleOutToTasksMaxTest() {
        int currentTasksCount = 5;
        int tasksMax = 100;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)currentTasksCount, (int)1, (int)tasksMax, (int)2, (long)300L, (long)0L);
        Assertions.assertThat((int)newTasksCount).isGreaterThan(currentTasksCount).isEqualTo(tasksMax);
    }

    @Test
    void newTasksCount_cannotScaleOutAfterReachingTasksMaxTest() {
        int currentTasksCount = 5;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)currentTasksCount, (int)2, (int)currentTasksCount, (int)2, (long)11L, (long)0L);
        Assertions.assertThat((int)newTasksCount).isEqualTo(currentTasksCount);
    }

    @Test
    void newTasksCount_scaleInTest() {
        int currentTasksCount = 20;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)currentTasksCount, (int)2, (int)20, (int)2, (long)8L, (long)12L);
        Assertions.assertThat((int)newTasksCount).isLessThan(currentTasksCount);
    }

    @Test
    void newTasksCount_scaleInToTasksMinTest() {
        int currentTasksCount = 20;
        int tasksMin = 12;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)currentTasksCount, (int)2, (int)20, (int)tasksMin, (long)8L, (long)12L);
        Assertions.assertThat((int)newTasksCount).isLessThan(currentTasksCount).isEqualTo(tasksMin);
    }

    @Test
    void newTasksCount_noScaleInRequiredTest() {
        int currentTasksCount = 10;
        int newTasksCount = TaskScaleCalculator.newTasksCount((int)currentTasksCount, (int)2, (int)20, (int)2, (long)8L, (long)2L);
        Assertions.assertThat((int)newTasksCount).isEqualTo(currentTasksCount);
    }
}

