/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.context.source;

import com.google.cloud.Timestamp;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.context.offset.LowWatermarkProvider;
import io.debezium.connector.spanner.context.source.SourceInfo;
import io.debezium.connector.spanner.context.source.SourceInfoFactory;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.ModType;
import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import io.debezium.connector.spanner.db.model.ValueCaptureType;
import io.debezium.connector.spanner.db.model.event.DataChangeEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SourceInfoFactoryTest {
    SourceInfoFactoryTest() {
    }

    @Test
    void testGetSourceInfoOldAndNewValues() throws InterruptedException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        SourceInfoFactory sourceInfoFactory = new SourceInfoFactory(connectorConfig, (LowWatermarkProvider)Mockito.mock(LowWatermarkProvider.class));
        StreamEventMetadata streamEventMetadata = (StreamEventMetadata)Mockito.mock(StreamEventMetadata.class);
        Mockito.when((Object)streamEventMetadata.getRecordReadAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        ArrayList rowType = new ArrayList();
        Timestamp commitTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Instant recordTimestamp = commitTimestamp.toSqlTimestamp().toInstant();
        Instant readAtTimestamp = commitTimestamp.toSqlTimestamp().toInstant();
        String serverTransactionId = "testId";
        Long recordSequence = 1L;
        Instant lowWatermark = null;
        Long numberRecordsInTransaction = 1L;
        DataChangeEvent dataChangeEvent = new DataChangeEvent("token", commitTimestamp, "testId", true, "1", "Table Name", rowType, new ArrayList(), ModType.INSERT, ValueCaptureType.OLD_AND_NEW_VALUES, 1L, 1L, "testTag=test", false, streamEventMetadata);
        SourceInfo expected = new SourceInfo(connectorConfig, dataChangeEvent.getTableName(), recordTimestamp, commitTimestamp.toSqlTimestamp().toInstant(), readAtTimestamp, serverTransactionId, recordSequence, lowWatermark, numberRecordsInTransaction, "testTag=test", Boolean.valueOf(false), ValueCaptureType.OLD_AND_NEW_VALUES.name(), "testToken", Integer.valueOf(0), Boolean.valueOf(false), Long.valueOf(1L));
        SourceInfo sourceInfo = sourceInfoFactory.getSourceInfo(0, new DataChangeEvent("token", commitTimestamp, "testId", true, "1", "Table Name", rowType, new ArrayList(), ModType.INSERT, ValueCaptureType.OLD_AND_NEW_VALUES, 1L, 1L, "testTag=test", false, streamEventMetadata));
        Assertions.assertEquals((Object)expected.getProjectId(), (Object)sourceInfo.getProjectId());
        Assertions.assertEquals((Object)expected.getInstanceId(), (Object)sourceInfo.getInstanceId());
        Assertions.assertEquals((Object)expected.getDatabaseId(), (Object)sourceInfo.getDatabaseId());
        Assertions.assertEquals((Object)expected.getChangeStreamName(), (Object)sourceInfo.getChangeStreamName());
        Assertions.assertEquals((Object)expected.getTableName(), (Object)sourceInfo.getTableName());
        Assertions.assertEquals((Object)expected.getRecordTimestamp(), (Object)sourceInfo.getRecordTimestamp());
        Assertions.assertEquals((Object)expected.getCommitTimestamp(), (Object)sourceInfo.getCommitTimestamp());
        Assertions.assertEquals((Object)expected.getServerTransactionId(), (Object)sourceInfo.getServerTransactionId());
        Assertions.assertEquals((Long)expected.getRecordSequence(), (Long)sourceInfo.getRecordSequence());
        Assertions.assertEquals((Object)expected.getLowWatermark(), (Object)sourceInfo.getLowWatermark());
        Assertions.assertEquals((Object)expected.getReadAtTimestamp(), (Object)sourceInfo.getReadAtTimestamp());
        Assertions.assertEquals((Long)expected.getNumberRecordsInTransaction(), (Long)sourceInfo.getNumberRecordsInTransaction());
    }

    @Test
    void testGetSourceInfoNewRow() throws InterruptedException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        SourceInfoFactory sourceInfoFactory = new SourceInfoFactory(connectorConfig, (LowWatermarkProvider)Mockito.mock(LowWatermarkProvider.class));
        StreamEventMetadata streamEventMetadata = (StreamEventMetadata)Mockito.mock(StreamEventMetadata.class);
        Mockito.when((Object)streamEventMetadata.getRecordReadAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        ArrayList rowType = new ArrayList();
        Timestamp commitTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        Instant recordTimestamp = commitTimestamp.toSqlTimestamp().toInstant();
        Instant readAtTimestamp = commitTimestamp.toSqlTimestamp().toInstant();
        String serverTransactionId = "testId";
        Long recordSequence = 1L;
        Instant lowWatermark = null;
        Long numberRecordsInTransaction = 1L;
        DataChangeEvent dataChangeEvent = new DataChangeEvent("token", commitTimestamp, "testId", true, "1", "Table Name", rowType, new ArrayList(), ModType.INSERT, ValueCaptureType.NEW_ROW, 1L, 1L, "testTag=test", false, streamEventMetadata);
        SourceInfo expected = new SourceInfo(connectorConfig, dataChangeEvent.getTableName(), recordTimestamp, commitTimestamp.toSqlTimestamp().toInstant(), readAtTimestamp, serverTransactionId, recordSequence, lowWatermark, numberRecordsInTransaction, "testTag=test", Boolean.valueOf(false), ValueCaptureType.NEW_ROW.name(), "testToken", Integer.valueOf(0), Boolean.valueOf(false), Long.valueOf(1L));
        SourceInfo sourceInfo = sourceInfoFactory.getSourceInfo(0, new DataChangeEvent("token", commitTimestamp, "testId", true, "1", "Table Name", rowType, new ArrayList(), ModType.INSERT, ValueCaptureType.NEW_ROW, 1L, 1L, "testTag=test", false, streamEventMetadata));
        Assertions.assertEquals((Object)expected.getValueCaptureType(), (Object)sourceInfo.getValueCaptureType());
        Assertions.assertEquals((Object)expected.getProjectId(), (Object)sourceInfo.getProjectId());
        Assertions.assertEquals((Object)expected.getInstanceId(), (Object)sourceInfo.getInstanceId());
        Assertions.assertEquals((Object)expected.getDatabaseId(), (Object)sourceInfo.getDatabaseId());
        Assertions.assertEquals((Object)expected.getChangeStreamName(), (Object)sourceInfo.getChangeStreamName());
        Assertions.assertEquals((Object)expected.getTableName(), (Object)sourceInfo.getTableName());
        Assertions.assertEquals((Object)expected.getRecordTimestamp(), (Object)sourceInfo.getRecordTimestamp());
        Assertions.assertEquals((Object)expected.getCommitTimestamp(), (Object)sourceInfo.getCommitTimestamp());
        Assertions.assertEquals((Object)expected.getServerTransactionId(), (Object)sourceInfo.getServerTransactionId());
        Assertions.assertEquals((Long)expected.getRecordSequence(), (Long)sourceInfo.getRecordSequence());
        Assertions.assertEquals((Object)expected.getLowWatermark(), (Object)sourceInfo.getLowWatermark());
        Assertions.assertEquals((Object)expected.getReadAtTimestamp(), (Object)sourceInfo.getReadAtTimestamp());
        Assertions.assertEquals((Long)expected.getNumberRecordsInTransaction(), (Long)sourceInfo.getNumberRecordsInTransaction());
    }

    @Test
    void testGetSourceInfoForLowWatermarkStamp() throws InterruptedException {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SourceInfoFactory sourceInfoFactory = new SourceInfoFactory(new SpannerConnectorConfig(configuration), (LowWatermarkProvider)Mockito.mock(LowWatermarkProvider.class));
        SourceInfo actualSourceInfoForLowWatermarkStamp = sourceInfoFactory.getSourceInfoForLowWatermarkStamp(TableId.getTableId((String)"Table Name"));
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.database());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.timestamp());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.sequence());
        Assertions.assertEquals((Object)"Table Name", (Object)actualSourceInfoForLowWatermarkStamp.getTableName());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.getChangeStreamName());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.getProjectId());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.getReadAtTimestamp());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.getInstanceId());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.getCommitTimestamp());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.getLowWatermark());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.getServerTransactionId());
        Assertions.assertNull((Object)actualSourceInfoForLowWatermarkStamp.getNumberRecordsInTransaction());
    }
}

