/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import com.google.cloud.spanner.DatabaseClient;
import io.debezium.config.Configuration;
import io.debezium.connector.spanner.config.validation.ChangeStreamValidator;
import io.debezium.connector.spanner.config.validation.ConfigurationValidator;
import java.util.Map;
import org.apache.kafka.common.config.ConfigValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ChangeStreamValidatorTest {
    ChangeStreamValidatorTest() {
    }

    @Test
    void validateSuccess() {
        Configuration configuration = Configuration.from(Map.of("gcp.spanner.project.id", "boxwood-weaver-353315", "gcp.spanner.instance.id", "kafka-connector", "gcp.spanner.database.id", "kafkaspan", "gcp.spanner.change.stream", "TestStream", "gcp.spanner.start.time", "2022-07-15T10:25:13.905049Z", "gcp.spanner.end.time", "2022-07-15T10:25:14.905049Z", "heartbeat.interval.ms", "300000", "heartbeat.topics.prefix", "heartbeat"));
        ConfigurationValidator.ValidationContext validationContext = new ConfigurationValidator.ValidationContext(configuration, Map.of());
        ChangeStreamValidator changeStreamValidator = (ChangeStreamValidator)Mockito.spy((Object)ChangeStreamValidator.withContext((ConfigurationValidator.ValidationContext)validationContext));
        ((ChangeStreamValidator)Mockito.doReturn((Object)true).when((Object)changeStreamValidator)).isStreamExist((DatabaseClient)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"TestStream"));
        Assertions.assertFalse((boolean)changeStreamValidator.isSuccess());
        changeStreamValidator.validate();
        Assertions.assertTrue((boolean)changeStreamValidator.isSuccess());
    }

    @Test
    void validateNotSuccess() {
        Configuration configuration = Configuration.from(Map.of("gcp.spanner.project.id", "boxwood-weaver-353315", "gcp.spanner.instance.id", "kafka-connector", "gcp.spanner.database.id", "kafkaspan", "gcp.spanner.start.time", "2022-07-15T10:25:13.905049Z", "gcp.spanner.end.time", "2022-07-15T10:25:14.905049Z", "heartbeat.interval.ms", "300000", "heartbeat.topics.prefix", "heartbeat"));
        ConfigurationValidator.ValidationContext validationContext = new ConfigurationValidator.ValidationContext(configuration, Map.of("gcp.spanner.change.stream", new ConfigValue("gcp.spanner.change.stream")));
        ChangeStreamValidator changeStreamValidator = (ChangeStreamValidator)Mockito.spy((Object)ChangeStreamValidator.withContext((ConfigurationValidator.ValidationContext)validationContext));
        ((ChangeStreamValidator)Mockito.doReturn((Object)false).when((Object)changeStreamValidator)).isStreamExist((DatabaseClient)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Assertions.assertFalse((boolean)changeStreamValidator.isSuccess());
        changeStreamValidator.validate();
        Assertions.assertFalse((boolean)changeStreamValidator.isSuccess());
    }
}

