/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.exception.SpannerConnectorException;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceState;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.TaskSyncContextMetricEvent;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.utils.TimeoutMeter;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSyncContextHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSyncContextHolder.class);
    private final MetricsEventPublisher metricsEventPublisher;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicReference<TaskSyncContext> taskSyncContextRef = new AtomicReference();
    private final Duration sleepInterval = Duration.ofMillis(100L);
    private final Clock clock;

    public TaskSyncContextHolder(MetricsEventPublisher metricsEventPublisher) {
        this.metricsEventPublisher = metricsEventPublisher;
        this.clock = Clock.system();
    }

    public final void init(TaskSyncContext taskSyncContext) {
        this.taskSyncContextRef.set(taskSyncContext);
        this.metricsEventPublisher.publishMetricEvent(new TaskSyncContextMetricEvent(taskSyncContext));
    }

    public TaskSyncContext get() {
        return this.taskSyncContextRef.get();
    }

    public String lockDebugString() {
        return "Lock Debug String {is locked: " + this.lock.isLocked() + ", isLockedByCurrentThread: " + this.lock.isHeldByCurrentThread() + ", lock debug string: " + this.lock.toString() + "current thread " + Thread.currentThread().getName();
    }

    public void update(UnaryOperator<TaskSyncContext> updateFunction) {
        this.updateAndGet(updateFunction);
    }

    public TaskSyncContext updateAndGet(UnaryOperator<TaskSyncContext> updateFunction) {
        TaskSyncContext taskSyncContext;
        this.lock.lock();
        try {
            taskSyncContext = this.taskSyncContextRef.updateAndGet(updateFunction);
        }
        finally {
            this.lock.unlock();
        }
        this.metricsEventPublisher.publishMetricEvent(new TaskSyncContextMetricEvent(taskSyncContext));
        return taskSyncContext;
    }

    public void awaitInitialization(Duration awaitTimeout) {
        LOGGER.debug("Task {} awaitInitialization: start", (Object)this.get().getTaskUid());
        TimeoutMeter timeout = TimeoutMeter.setTimeout(awaitTimeout);
        while (RebalanceState.START_INITIAL_SYNC.equals((Object)this.get().getRebalanceState())) {
            if (!timeout.isExpired()) continue;
            LOGGER.debug("Await task initialization timeout expired");
            throw new SpannerConnectorException("Await task initialization timeout expired");
        }
        LOGGER.debug("Task {} awaitInitialization: end", (Object)this.get().getTaskUid());
    }

    public void awaitNewEpoch() {
        while (!RebalanceState.NEW_EPOCH_STARTED.equals((Object)this.get().getRebalanceState())) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            Metronome metronome = Metronome.sleeper((Duration)this.sleepInterval, (Clock)this.clock);
            try {
                metronome.pause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

