/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics;

import com.google.cloud.Timestamp;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerConnectorTask;
import io.debezium.connector.spanner.SpannerErrorHandler;
import io.debezium.connector.spanner.function.BlockingSupplier;
import io.debezium.connector.spanner.metrics.SpannerMeter;
import io.debezium.connector.spanner.metrics.latency.LatencyCalculator;
import io.debezium.connector.spanner.metrics.latency.Statistics;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Properties;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SpannerMeterTest {
    SpannerMeterTest() {
    }

    @Test
    void testConstructor() throws InterruptedException {
        SpannerConnectorTask task = new SpannerConnectorTask();
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration);
        BlockingSupplier lowWatermarkSupplier = (BlockingSupplier)Mockito.mock(BlockingSupplier.class);
        Configuration configuration1 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration1.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration1.asProperties()).thenReturn((Object)new Properties());
        SpannerErrorHandler spannerErrorHandler = new SpannerErrorHandler((SpannerConnectorTask)Mockito.mock(SpannerConnectorTask.class), (ChangeEventQueue)Mockito.mock(ChangeEventQueue.class));
        SpannerMeter actualSpannerMeter = new SpannerMeter(task, connectorConfig, spannerErrorHandler, lowWatermarkSupplier);
        Assertions.assertTrue((boolean)actualSpannerMeter.getCapturedTables().isEmpty());
        Assertions.assertNull((Object)actualSpannerMeter.getTaskUid());
        Assertions.assertNull((Object)actualSpannerMeter.getLowWatermarkLag());
        Assertions.assertEquals((int)0, (int)actualSpannerMeter.getNumberOfActiveQueries());
        Assertions.assertEquals((int)0, (int)actualSpannerMeter.getErrorCount());
        Assertions.assertEquals((int)0, (int)actualSpannerMeter.getNumberOfPartitionsDetected());
        Assertions.assertEquals((int)0, (int)actualSpannerMeter.getNumberOfQueriesIssuedTotal());
        Statistics connectorLatency = actualSpannerMeter.getConnectorLatency();
        Assertions.assertNull((Object)connectorLatency.getMinValue());
        Statistics commitToEmitLatency = actualSpannerMeter.getCommitToEmitLatency();
        Assertions.assertEquals(null, (Double)commitToEmitLatency.getValueAtP95());
        Assertions.assertNull((Object)commitToEmitLatency.getMinValue());
        Statistics totalLatency = actualSpannerMeter.getTotalLatency();
        Assertions.assertEquals(null, (Double)totalLatency.getValueAtP50());
        Assertions.assertNull((Object)totalLatency.getMinValue());
        Statistics lowWatermarkLagLatency = actualSpannerMeter.getLowWatermarkLagLatency();
        Assertions.assertNull((Object)lowWatermarkLagLatency.getMaxValue());
        Assertions.assertEquals(null, (Double)lowWatermarkLagLatency.getValueAtP95());
        Assertions.assertNull((Object)actualSpannerMeter.getEmitToPublishLatency().getAverageValue());
        Assertions.assertEquals(null, (Double)connectorLatency.getValueAtP50());
    }

    @Test
    void testCaptureTable() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        SpannerMeter spannerMeter = new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> null);
        spannerMeter.captureTable((DataCollectionId)new TableId("Catalog Name", "Schema Name", "Table Name"));
        Assertions.assertEquals((int)1, (int)spannerMeter.getCapturedTables().size());
    }

    @Test
    void testReset() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        SpannerMeter spannerMeter = new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> null);
        spannerMeter.captureTable((DataCollectionId)new TableId("Catalog Name", "Schema Name", "Table Name"));
        Assertions.assertEquals((int)1, (int)spannerMeter.getCapturedTables().size());
        spannerMeter.reset();
        Assertions.assertTrue((boolean)spannerMeter.getCapturedTables().isEmpty());
    }

    @Test
    void testGetTaskUid() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Assertions.assertNull((Object)new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> null).getTaskUid());
    }

    private static Stream<Arguments> lowWatermarkLagProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{true, LatencyCalculator.getTimeBehindLowWatermark((Timestamp)Timestamp.ofTimeMicroseconds((long)0L))}), Arguments.of((Object[])new Object[]{false, null}));
    }

    @ParameterizedTest
    @MethodSource(value={"lowWatermarkLagProvider"})
    void testGetLowWatermarkLag(Boolean lowWatermarkEnabled, Long expected) throws InterruptedException {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Mockito.when((Object)connectorConfig.isLowWatermarkEnabled()).thenReturn((Object)lowWatermarkEnabled);
        SpannerMeter spannerMeter = new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> Timestamp.ofTimeMicroseconds((long)0L));
        Long lowWatermarkLag = spannerMeter.getLowWatermarkLag();
        if (expected == null) {
            Assertions.assertNull((Object)lowWatermarkLag);
        } else {
            Assertions.assertTrue((lowWatermarkLag >= expected ? 1 : 0) != 0);
        }
    }

    private static Stream<Arguments> lowWatermarkProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{true, Timestamp.ofTimeMicroseconds((long)0L)}), Arguments.of((Object[])new Object[]{false, null}));
    }

    @ParameterizedTest
    @MethodSource(value={"lowWatermarkProvider"})
    void testGetLowWatermark(Boolean lowWatermarkEnabled, Timestamp expected) throws InterruptedException {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        Mockito.when((Object)connectorConfig.isLowWatermarkEnabled()).thenReturn((Object)lowWatermarkEnabled);
        SpannerMeter spannerMeter = new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> Timestamp.ofTimeMicroseconds((long)0L));
        Timestamp lowWatermark = spannerMeter.getLowWatermark();
        Assertions.assertEquals((Object)expected, (Object)lowWatermark);
    }

    @Test
    void testGetNumberOfPartitionsDetected() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        SpannerMeter spannerMeter = new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> null);
        Assertions.assertEquals((int)0, (int)spannerMeter.getNumberOfPartitionsDetected());
    }

    @Test
    void testGetNumberOfQueriesIssuedTotal() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        SpannerMeter spannerMeter = new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> null);
        Assertions.assertEquals((int)0, (int)spannerMeter.getNumberOfQueriesIssuedTotal());
    }

    @Test
    void testGetNumberOfActiveQueries() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        SpannerMeter spannerMeter = new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> null);
        Assertions.assertEquals((int)0, (int)spannerMeter.getNumberOfActiveQueries());
    }

    @Test
    void testGetErrorCount() {
        SpannerConnectorConfig connectorConfig = (SpannerConnectorConfig)Mockito.mock(SpannerConnectorConfig.class);
        SpannerMeter spannerMeter = new SpannerMeter(new SpannerConnectorTask(), connectorConfig, null, () -> null);
        Assertions.assertEquals((int)0, (int)spannerMeter.getErrorCount());
    }
}

