/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.function.Predicates;
import io.debezium.schema.DataCollectionFilters;
import java.util.function.Predicate;

public class SpannerTableFilter
implements DataCollectionFilters.DataCollectionFilter<TableId> {
    private Predicate<String> includePredicate;
    private Predicate<String> excludePredicate;

    public SpannerTableFilter(SpannerConnectorConfig connectorConfig) {
        if (connectorConfig.tableIncludeList() != null) {
            this.includePredicate = Predicates.includes((String)connectorConfig.tableIncludeList());
        }
        if (connectorConfig.tableExcludeList() != null) {
            this.excludePredicate = Predicates.excludes((String)connectorConfig.tableExcludeList());
        }
    }

    public boolean isIncluded(TableId tableId) {
        if (this.includePredicate != null) {
            return this.includePredicate.test(tableId.getTableName());
        }
        return this.excludePredicate == null || this.excludePredicate.test(tableId.getTableName());
    }
}

