/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.TaskSyncPublisher;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceState;
import io.debezium.connector.spanner.kafka.internal.model.SyncEventMetadata;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.SyncEventMerger;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import io.debezium.connector.spanner.task.state.SyncEvent;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import io.debezium.function.BlockingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncEventHandler.class);
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final TaskSyncPublisher taskSyncPublisher;
    private final BlockingConsumer<TaskStateChangeEvent> eventConsumer;

    public SyncEventHandler(TaskSyncContextHolder taskSyncContextHolder, TaskSyncPublisher taskSyncPublisher, BlockingConsumer<TaskStateChangeEvent> eventConsumer) {
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.taskSyncPublisher = taskSyncPublisher;
        this.eventConsumer = eventConsumer;
    }

    public void updateCurrentOffset(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        if (inSync == null) {
            return;
        }
        if (this.skipFromMismatchingGeneration(inSync)) {
            return;
        }
        LOGGER.debug("Task {} - before update task sync topic offset with {}", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)metadata.getOffset());
        this.taskSyncContextHolder.update(oldContext -> oldContext.toBuilder().currentKafkaRecordOffset(metadata.getOffset()).build());
        LOGGER.debug("Task {} - update task sync topic offset with {}", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)metadata.getOffset());
    }

    public void processPreviousStates(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        if (!RebalanceState.START_INITIAL_SYNC.equals((Object)this.taskSyncContextHolder.get().getRebalanceState())) {
            return;
        }
        if (this.skipFromMismatchingGeneration(inSync)) {
            if (inSync != null) {
                long inGeneration = inSync.getRebalanceGenerationId();
                long currentGeneration = this.taskSyncContextHolder.get().getRebalanceGenerationId();
                LOGGER.info("Task {}, skipFromMismatchingGeneration: currentGen: {}, inGen: {}, inTaskUid: {}, message type {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), currentGeneration, inGeneration, inSync.getTaskUid(), inSync.getMessageType()});
            }
            if (metadata.isCanInitiateRebalancing()) {
                LOGGER.info("task {}, finished processing all previous sync event messages with end offset {}, can initiate rebalancing with rebalance generation ID {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), metadata.getOffset(), this.taskSyncContextHolder.get().getRebalanceGenerationId()});
                this.taskSyncContextHolder.update(context -> context.toBuilder().rebalanceState(RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED).build());
            }
            return;
        }
        if (inSync != null) {
            if (inSync.getMessageType() == MessageTypeEnum.NEW_EPOCH) {
                this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeNewEpoch(context, inSync));
            } else if (inSync.getMessageType() == MessageTypeEnum.REBALANCE_ANSWER) {
                this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeRebalanceAnswer(context, inSync));
            } else if (inSync.getMessageType() == MessageTypeEnum.UPDATE_EPOCH) {
                this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeEpochUpdate(context, inSync));
            } else {
                this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeIncrementalTaskSyncEvent(context, inSync));
            }
        }
        if (metadata.isCanInitiateRebalancing()) {
            LOGGER.info("Task {} - processPreviousStates - switch state to INITIAL_INCREMENTED_STATE_COMPLETED", (Object)this.taskSyncContextHolder.get().getTaskUid());
            long newPartitions = this.taskSyncContextHolder.get().getNumPartitions() + this.taskSyncContextHolder.get().getNumSharedPartitions();
            LOGGER.info("task {}, finished processing all previous sync event messages with end offset {}, can initiate rebalancing with rebalance generation ID {}, task has total partitions {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), metadata.getOffset(), this.taskSyncContextHolder.get().getRebalanceGenerationId(), newPartitions});
            this.taskSyncContextHolder.update(context -> context.toBuilder().rebalanceState(RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED).build());
            LOGGER.info("Task {} - now initialized with epoch offset {}", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)this.taskSyncContextHolder.get().getEpochOffsetHolder().getEpochOffset());
            this.taskSyncContextHolder.get().checkDuplication(true, "Finished Initializing Task State");
        }
    }

    public void processNewEpoch(TaskSyncEvent inSync, SyncEventMetadata metadata) throws InterruptedException, IllegalStateException {
        LOGGER.info("Task {} - processNewEpoch: metadata {}, rebalance State {}, rebalanceId: {}, current task {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), metadata, this.taskSyncContextHolder.get().getRebalanceState(), inSync.getRebalanceGenerationId()});
        TaskSyncContext newContext = this.taskSyncContextHolder.updateAndGet(context -> SyncEventMerger.mergeNewEpoch(context, inSync));
        LOGGER.info("Task {} - SyncEventHandler sending response for new epoch", (Object)this.taskSyncContextHolder.get().getTaskUid());
        this.taskSyncPublisher.send(newContext.buildCurrentTaskSyncEvent());
        LOGGER.info("Task {} - SyncEventHandler sent response for new epoch", (Object)this.taskSyncContextHolder.get().getTaskUid());
        this.eventConsumer.accept((Object)new SyncEvent());
    }

    public void processUpdateEpoch(TaskSyncEvent inSync, SyncEventMetadata metadata) throws InterruptedException {
        LOGGER.debug("Task {} - SyncEventHandler updating from update epoch", (Object)this.taskSyncContextHolder.get().getTaskUid());
        this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeEpochUpdate(context, inSync));
        LOGGER.debug("Task {} - SyncEventHandler updated from update epoch", (Object)this.taskSyncContextHolder.get().getTaskUid());
        this.eventConsumer.accept((Object)new SyncEvent());
    }

    public void processRegularMessage(TaskSyncEvent inSync, SyncEventMetadata metadata) throws InterruptedException {
        LOGGER.debug("Task {} - process regular message event", (Object)this.taskSyncContextHolder.get().getTaskUid());
        this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeIncrementalTaskSyncEvent(context, inSync));
        LOGGER.debug("Task {} - Finished processing regular message event", (Object)this.taskSyncContextHolder.get().getTaskUid());
    }

    public void processRebalanceAnswer(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        LOGGER.debug("Task {} - process sync event - rebalance answer", (Object)this.taskSyncContextHolder.get().getTaskUid());
        this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeRebalanceAnswer(context, inSync));
        LOGGER.debug("Task {} - process sync event - updated from rebalance answer", (Object)this.taskSyncContextHolder.get().getTaskUid());
    }

    private boolean skipFromMismatchingGeneration(TaskSyncEvent inSync) {
        if (inSync != null) {
            long inGeneration = inSync.getRebalanceGenerationId();
            long currentGeneration = this.taskSyncContextHolder.get().getRebalanceGenerationId();
            if (inSync.getMessageType() == MessageTypeEnum.NEW_EPOCH || inSync.getMessageType() == MessageTypeEnum.REBALANCE_ANSWER || inSync.getMessageType() == MessageTypeEnum.UPDATE_EPOCH) {
                return inGeneration < currentGeneration;
            }
        }
        return false;
    }

    public void process(TaskSyncEvent inSync, SyncEventMetadata metadata) throws InterruptedException, IllegalStateException {
        if (inSync == null) {
            return;
        }
        if (this.skipFromMismatchingGeneration(inSync)) {
            LOGGER.info("Task {}, skipping message from task {}, from prior generation {} and message type {} with current generation {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), inSync.getTaskUid(), inSync.getRebalanceGenerationId(), inSync.getMessageType(), this.taskSyncContextHolder.get().getRebalanceGenerationId()});
            return;
        }
        try {
            if (inSync.getMessageType() == MessageTypeEnum.REGULAR) {
                this.processRegularMessage(inSync, metadata);
            } else if (inSync.getMessageType() == MessageTypeEnum.REBALANCE_ANSWER) {
                this.processRebalanceAnswer(inSync, metadata);
            } else if (inSync.getMessageType() == MessageTypeEnum.UPDATE_EPOCH) {
                this.processUpdateEpoch(inSync, metadata);
            } else if (inSync.getMessageType() == MessageTypeEnum.NEW_EPOCH) {
                this.processNewEpoch(inSync, metadata);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during processing task message task Uid {}, message type {}, exception", new Object[]{inSync.getTaskUid(), inSync.getMessageType(), e});
            throw e;
        }
    }
}

