/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor.heartbeat;

import io.debezium.connector.spanner.processor.heartbeat.SpannerHeartbeat;
import io.debezium.function.BlockingConsumer;
import io.debezium.schema.SchemaNameAdjuster;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SpannerHeartbeatTest {
    SpannerHeartbeatTest() {
    }

    @Test
    void testConstructor() {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        try (SpannerHeartbeat spannerHeartbeat = new SpannerHeartbeat("Topic Name", schemaNameAdjuster);){
            Assertions.assertTrue((boolean)spannerHeartbeat.isEnabled());
        }
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
    }

    @Test
    void testConstructorThrows() {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenThrow(new Throwable[]{new IllegalStateException()});
        Assertions.assertThrows(IllegalStateException.class, () -> new SpannerHeartbeat("Topic Name", schemaNameAdjuster));
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster)).adjust((String)Mockito.any());
    }

    @Test
    void testHeartbeatWithNullOffset() throws InterruptedException {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        try (SpannerHeartbeat spannerHeartbeat = (SpannerHeartbeat)Mockito.spy((Object)new SpannerHeartbeat("Topic Name", schemaNameAdjuster));){
            HashMap<String, String> partition = new HashMap<String, String>();
            partition.put("partitionToken", "v1");
            BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
            ((BlockingConsumer)Mockito.doNothing().when((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            Map nullOffset = null;
            spannerHeartbeat.heartbeat(partition, nullOffset, consumer);
            ((BlockingConsumer)Mockito.verify((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            ((SpannerHeartbeat)Mockito.verify((Object)spannerHeartbeat)).forcedBeat((Map)Mockito.any(), (Map)Mockito.any(), (BlockingConsumer)Mockito.any());
        }
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
    }

    @Test
    void testHeartbeatWithEmptyOffset() throws InterruptedException {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        try (SpannerHeartbeat spannerHeartbeat = (SpannerHeartbeat)Mockito.spy((Object)new SpannerHeartbeat("Topic Name", schemaNameAdjuster));){
            HashMap<String, String> partition = new HashMap<String, String>();
            partition.put("partitionToken", "v1");
            BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
            ((BlockingConsumer)Mockito.doNothing().when((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            spannerHeartbeat.heartbeat(partition, new HashMap(), consumer);
            ((BlockingConsumer)Mockito.verify((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            ((SpannerHeartbeat)Mockito.verify((Object)spannerHeartbeat)).forcedBeat((Map)Mockito.any(), (Map)Mockito.any(), (BlockingConsumer)Mockito.any());
        }
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
    }

    @Test
    void testForcedBeat() throws InterruptedException {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        try (SpannerHeartbeat spannerHeartbeat = (SpannerHeartbeat)Mockito.spy((Object)new SpannerHeartbeat("Topic Name", schemaNameAdjuster));){
            HashMap<String, String> partition = new HashMap<String, String>();
            partition.put("partitionToken", "v1");
            HashMap<String, String> offset = new HashMap<String, String>();
            offset.put("partitionToken", "v1");
            BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
            ((BlockingConsumer)Mockito.doNothing().when((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            spannerHeartbeat.heartbeat(partition, offset, consumer);
            ((BlockingConsumer)Mockito.verify((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            ((SpannerHeartbeat)Mockito.verify((Object)spannerHeartbeat)).forcedBeat((Map)Mockito.any(), (Map)Mockito.any(), (BlockingConsumer)Mockito.any());
        }
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
    }

    @Test
    void testForcedBeatWithEmptyOffset() throws InterruptedException {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        try (SpannerHeartbeat spannerHeartbeat = (SpannerHeartbeat)Mockito.spy((Object)new SpannerHeartbeat("Topic Name", schemaNameAdjuster));){
            HashMap<String, String> partition = new HashMap<String, String>();
            partition.put("partitionToken", "v1");
            BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
            ((BlockingConsumer)Mockito.doNothing().when((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            spannerHeartbeat.heartbeat(partition, new HashMap(), consumer);
            ((BlockingConsumer)Mockito.verify((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            ((SpannerHeartbeat)Mockito.verify((Object)spannerHeartbeat)).forcedBeat((Map)Mockito.any(), (Map)Mockito.any(), (BlockingConsumer)Mockito.any());
        }
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
    }

    @Test
    void testForcedBeatWithNullOffset() throws InterruptedException {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        try (SpannerHeartbeat spannerHeartbeat = (SpannerHeartbeat)Mockito.spy((Object)new SpannerHeartbeat("Topic Name", schemaNameAdjuster));){
            HashMap<String, String> partition = new HashMap<String, String>();
            partition.put("partitionToken", "v1");
            BlockingConsumer consumer = (BlockingConsumer)Mockito.mock(BlockingConsumer.class);
            ((BlockingConsumer)Mockito.doNothing().when((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            Map nullOffset = null;
            spannerHeartbeat.heartbeat(partition, nullOffset, consumer);
            ((BlockingConsumer)Mockito.verify((Object)consumer)).accept((Object)((SourceRecord)Mockito.any()));
            ((SpannerHeartbeat)Mockito.verify((Object)spannerHeartbeat)).forcedBeat((Map)Mockito.any(), (Map)Mockito.any(), (BlockingConsumer)Mockito.any());
        }
        ((SchemaNameAdjuster)Mockito.verify((Object)schemaNameAdjuster, (VerificationMode)Mockito.atLeast((int)1))).adjust((String)Mockito.any());
    }

    @Test
    void testPartitionTokenKey() {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        SpannerHeartbeat spannerHeartbeat = new SpannerHeartbeat("Topic Name", schemaNameAdjuster);
        String value = "value";
        Struct struct = spannerHeartbeat.partitionTokenKey(value);
        Assertions.assertEquals((Object)value, (Object)struct.get("partitionToken"));
    }

    @Test
    void testMessageValue() {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        SpannerHeartbeat spannerHeartbeat = new SpannerHeartbeat("Topic Name", schemaNameAdjuster);
        Struct struct = spannerHeartbeat.messageValue();
        Assertions.assertNotNull((Object)struct.get("ts_ms"));
    }

    @Test
    void testHeartbeatRecord() {
        SchemaNameAdjuster schemaNameAdjuster = (SchemaNameAdjuster)Mockito.mock(SchemaNameAdjuster.class);
        Mockito.when((Object)schemaNameAdjuster.adjust((String)Mockito.any())).thenReturn((Object)"Adjust");
        SpannerHeartbeat spannerHeartbeat = new SpannerHeartbeat("Topic Name", schemaNameAdjuster);
        Assertions.assertNotNull((Object)spannerHeartbeat.heartbeatRecord(Map.of("partitionToken", "v"), Map.of("partitionToken", "v")));
    }
}

