/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.latency;

import io.debezium.connector.spanner.metrics.latency.QuantileMeter;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class QuantileMeterTest {
    QuantileMeterTest() {
    }

    @Test
    void testGetCount() {
        Assertions.assertEquals((double)0.0, (double)new QuantileMeter(Duration.ofSeconds(10L), null).getCount());
    }

    @Test
    void testAddValue() throws InterruptedException {
        QuantileMeter quantileMeter = new QuantileMeter(Duration.ofSeconds(10L), (Consumer)Mockito.mock(Consumer.class));
        Assertions.assertArrayEquals((Object[])new Double[]{null, null, null}, (Object[])quantileMeter.getValuesAtQuantiles());
        quantileMeter.addValue(20.0);
        quantileMeter.start();
        Thread.sleep(1000L);
        Assertions.assertFalse((boolean)Arrays.equals((Object[])new Double[]{0.0, 0.0, 0.0}, (Object[])quantileMeter.getValuesAtQuantiles()));
    }

    @Test
    void testGetValueAtQuantile() {
        QuantileMeter quantileMeter = new QuantileMeter(Duration.ofSeconds(10L), (Consumer)Mockito.mock(Consumer.class));
        Assertions.assertEquals(null, (Double)quantileMeter.getValueAtQuantile(10.0));
    }

    @Test
    void testReset() {
        QuantileMeter quantileMeter = new QuantileMeter(Duration.ofSeconds(10L), (Consumer)Mockito.mock(Consumer.class));
        quantileMeter.reset();
        Assertions.assertEquals((double)0.0, (double)quantileMeter.getCount());
    }

    @Test
    void testShutdown() {
        QuantileMeter quantileMeter = new QuantileMeter(Duration.ofSeconds(10L), (Consumer)Mockito.mock(Consumer.class));
        quantileMeter.shutdown();
        Assertions.assertEquals((double)0.0, (double)quantileMeter.getCount());
    }
}

