/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.schema.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.connector.spanner.db.mapper.parser.ColumnTypeParser;
import io.debezium.connector.spanner.db.model.schema.ColumnType;
import io.debezium.connector.spanner.schema.mapper.ColumnTypeSchemaMapper;
import io.debezium.connector.spanner.schema.mapper.FieldJsonNodeValueMapper;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class FieldJsonNodeValueMapperTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    FieldJsonNodeValueMapperTest() {
    }

    private static Stream<Arguments> schemaProvider() throws JsonProcessingException {
        return Stream.of(Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"array_element_type\":{\"code\":\"FLOAT64\"},\"code\":\"ARRAY\"}"), (boolean)true), OBJECT_MAPPER.readTree("{\"value\": [1.1, 2, 3.4] }").get("value"), List.of(Double.valueOf(1.1), Double.valueOf(2.0), Double.valueOf(3.4))}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"STRING\"}"), (boolean)true), OBJECT_MAPPER.readTree("{\"value\": \"test_string\" }").get("value"), "test_string"}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"INT64\"}"), (boolean)true), OBJECT_MAPPER.readTree("{\"value\": 10 }").get("value"), 10L}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"BOOL\"}"), (boolean)true), OBJECT_MAPPER.readTree("{\"value\": true }").get("value"), true}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"FLOAT64\"}"), (boolean)true), OBJECT_MAPPER.readTree("{\"value\": 1.123 }").get("value"), 1.123}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"BYTES\"}"), (boolean)true), OBJECT_MAPPER.readTree("{\"value\": \"test\" }").get("value"), ByteBuffer.wrap(Base64.getDecoder().decode("test".getBytes(StandardCharsets.UTF_8)))}));
    }

    @ParameterizedTest
    @MethodSource(value={"schemaProvider"})
    void parse(Schema schema, JsonNode objectNode, Object expected) {
        Field field = new Field("test", 0, schema);
        Object value = FieldJsonNodeValueMapper.getValue((Field)field, (JsonNode)objectNode);
        Assertions.assertEquals((Object)expected, (Object)value);
    }
}

