/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;

public class NetworkClientDelegate
implements AutoCloseable {
    private final KafkaClient client;
    private final Time time;
    private final Logger log;
    private final int requestTimeoutMs;
    private final Queue<UnsentRequest> unsentRequests;
    private final long retryBackoffMs;

    public NetworkClientDelegate(Time time, ConsumerConfig config, LogContext logContext, KafkaClient client) {
        this.time = time;
        this.client = client;
        this.log = logContext.logger(this.getClass());
        this.unsentRequests = new ArrayDeque<UnsentRequest>();
        this.requestTimeoutMs = config.getInt("request.timeout.ms");
        this.retryBackoffMs = config.getLong("retry.backoff.ms");
    }

    public void poll(long timeoutMs, long currentTimeMs) {
        this.trySend(currentTimeMs);
        long pollTimeoutMs = timeoutMs;
        if (!this.unsentRequests.isEmpty()) {
            pollTimeoutMs = Math.min(this.retryBackoffMs, pollTimeoutMs);
        }
        this.client.poll(pollTimeoutMs, currentTimeMs);
        this.checkDisconnects();
    }

    private void trySend(long currentTimeMs) {
        Iterator iterator = this.unsentRequests.iterator();
        while (iterator.hasNext()) {
            UnsentRequest unsent = (UnsentRequest)iterator.next();
            unsent.timer.update(currentTimeMs);
            if (unsent.timer.isExpired()) {
                iterator.remove();
                unsent.handler.onFailure(new TimeoutException("Failed to send request after " + unsent.timer.timeoutMs() + " ms."));
                continue;
            }
            if (!this.doSend(unsent, currentTimeMs)) continue;
            iterator.remove();
        }
    }

    private boolean doSend(UnsentRequest r, long currentTimeMs) {
        Node node = r.node.orElse(this.client.leastLoadedNode(currentTimeMs));
        if (node == null || this.nodeUnavailable(node)) {
            this.log.debug("No broker available to send the request: {}. Retrying.", (Object)r);
            return false;
        }
        ClientRequest request = this.makeClientRequest(r, node, currentTimeMs);
        if (!this.client.ready(node, currentTimeMs)) {
            this.log.debug("Node is not ready, handle the request in the next event loop: node={}, request={}", (Object)node, (Object)r);
            return false;
        }
        this.client.send(request, currentTimeMs);
        return true;
    }

    private void checkDisconnects() {
        Iterator iter = this.unsentRequests.iterator();
        while (iter.hasNext()) {
            UnsentRequest u = (UnsentRequest)iter.next();
            if (!u.node.isPresent() || !this.client.connectionFailed((Node)u.node.get())) continue;
            iter.remove();
            AuthenticationException authenticationException = this.client.authenticationException((Node)u.node.get());
            u.handler.onFailure(authenticationException);
        }
    }

    private ClientRequest makeClientRequest(UnsentRequest unsent, Node node, long currentTimeMs) {
        return this.client.newClientRequest(node.idString(), unsent.requestBuilder, currentTimeMs, true, (int)unsent.timer.remainingMs(), unsent.handler);
    }

    public Node leastLoadedNode() {
        return this.client.leastLoadedNode(this.time.milliseconds());
    }

    public void send(UnsentRequest r) {
        r.setTimer(this.time, this.requestTimeoutMs);
        this.unsentRequests.add(r);
    }

    public void wakeup() {
        this.client.wakeup();
    }

    public boolean nodeUnavailable(Node node) {
        return this.client.connectionFailed(node) && this.client.connectionDelay(node, this.time.milliseconds()) > 0L;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public void addAll(List<UnsentRequest> requests) {
        requests.forEach(u -> u.setTimer(this.time, this.requestTimeoutMs));
        this.unsentRequests.addAll(requests);
    }

    public static class FutureCompletionHandler
    implements RequestCompletionHandler {
        private final CompletableFuture<ClientResponse> future = new CompletableFuture();

        FutureCompletionHandler() {
        }

        public void onFailure(RuntimeException e) {
            this.future.completeExceptionally(e);
        }

        public CompletableFuture<ClientResponse> future() {
            return this.future;
        }

        @Override
        public void onComplete(ClientResponse response) {
            if (response.authenticationException() != null) {
                this.onFailure(response.authenticationException());
            } else if (response.wasDisconnected()) {
                this.onFailure(DisconnectException.INSTANCE);
            } else if (response.versionMismatch() != null) {
                this.onFailure(response.versionMismatch());
            } else {
                this.future.complete(response);
            }
        }
    }

    public static class UnsentRequest {
        private final AbstractRequest.Builder<?> requestBuilder;
        private final FutureCompletionHandler handler;
        private Optional<Node> node;
        private Timer timer;

        public UnsentRequest(AbstractRequest.Builder<?> requestBuilder, Optional<Node> node) {
            this(requestBuilder, node, new FutureCompletionHandler());
        }

        public UnsentRequest(AbstractRequest.Builder<?> requestBuilder, Optional<Node> node, FutureCompletionHandler handler) {
            Objects.requireNonNull(requestBuilder);
            this.requestBuilder = requestBuilder;
            this.node = node;
            this.handler = handler;
        }

        public void setTimer(Time time, long requestTimeoutMs) {
            this.timer = time.timer(requestTimeoutMs);
        }

        CompletableFuture<ClientResponse> future() {
            return this.handler.future;
        }

        RequestCompletionHandler callback() {
            return this.handler;
        }

        AbstractRequest.Builder<?> requestBuilder() {
            return this.requestBuilder;
        }

        public String toString() {
            return "UnsentRequest(builder=" + this.requestBuilder + ")";
        }
    }

    public static class PollResult {
        public final long timeUntilNextPollMs;
        public final List<UnsentRequest> unsentRequests;

        public PollResult(long timeMsTillNextPoll, List<UnsentRequest> unsentRequests) {
            this.timeUntilNextPollMs = timeMsTillNextPoll;
            this.unsentRequests = Collections.unmodifiableList(unsentRequests);
        }
    }
}

