/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.encoding;

import com.datadoghq.sketch.ddsketch.encoding.Input;
import com.datadoghq.sketch.ddsketch.encoding.Output;
import java.io.IOException;
import java.util.Objects;

public final class Flag {
    public static final Flag ZERO_COUNT = new Flag(Type.SKETCH_FEATURES, 1);
    public static final Flag COUNT = new Flag(Type.SKETCH_FEATURES, 40);
    public static final Flag SUM = new Flag(Type.SKETCH_FEATURES, 33);
    public static final Flag MIN = new Flag(Type.SKETCH_FEATURES, 34);
    public static final Flag MAX = new Flag(Type.SKETCH_FEATURES, 35);
    private final byte marker;

    private Flag(byte marker) {
        this.marker = marker;
    }

    Flag(Type type, byte subFlag) {
        this((byte)(type.ordinal() | subFlag << 2));
    }

    final byte marker() {
        return this.marker;
    }

    public Type type() {
        return Type.values()[this.marker & 3];
    }

    public void encode(Output output) throws IOException {
        output.writeByte(this.marker);
    }

    public static Flag decode(Input input) throws IOException {
        return new Flag(input.readByte());
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.marker == ((Flag)o).marker;
    }

    public int hashCode() {
        return Objects.hash(this.marker);
    }

    public static enum Type {
        SKETCH_FEATURES,
        POSITIVE_STORE,
        INDEX_MAPPING,
        NEGATIVE_STORE;

    }
}

