/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.TaskTestHelper;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskSyncContextTest {
    TaskSyncContextTest() {
    }

    @Test
    void testEmptyTaskSyncContext() {
        TaskSyncContext taskSyncContext = this.buildEmptyTaskSyncContext();
        TaskState task0 = TaskTestHelper.generateTaskStateWithPartitions("task0", List.of(), List.of());
        TaskSyncEvent syncEvent = taskSyncContext.buildRebalanceAnswerTaskSyncEvent();
        Assertions.assertEquals((Object)"task0", (Object)syncEvent.getTaskUid());
        Assertions.assertEquals((int)1, (int)syncEvent.getTaskStates().size());
        Assertions.assertEquals((Object)MessageTypeEnum.REBALANCE_ANSWER, (Object)syncEvent.getMessageType());
        syncEvent = taskSyncContext.buildCurrentTaskSyncEvent();
        Assertions.assertEquals((Object)"task0", (Object)syncEvent.getTaskUid());
        Assertions.assertEquals((int)1, (int)syncEvent.getTaskStates().size());
        Assertions.assertEquals((Object)MessageTypeEnum.REGULAR, (Object)syncEvent.getMessageType());
        syncEvent = taskSyncContext.buildUpdateEpochTaskSyncEvent();
        Assertions.assertEquals((Object)"task0", (Object)syncEvent.getTaskUid());
        Assertions.assertEquals((int)3, (int)syncEvent.getTaskStates().size());
        Assertions.assertEquals((Object)MessageTypeEnum.UPDATE_EPOCH, (Object)syncEvent.getMessageType());
        syncEvent = taskSyncContext.buildNewEpochTaskSyncEvent();
        Assertions.assertEquals((Object)"task0", (Object)syncEvent.getTaskUid());
        Assertions.assertEquals((int)3, (int)syncEvent.getTaskStates().size());
        Assertions.assertEquals((Object)MessageTypeEnum.NEW_EPOCH, (Object)syncEvent.getMessageType());
    }

    @Test
    void testPopulatedTaskSyncContext() {
        TaskSyncContext taskSyncContext = this.buildTaskSyncContextWithPartitions();
        TaskState task0 = TaskTestHelper.generateTaskStateWithPartitions("task0", List.of(), List.of());
        TaskSyncEvent syncEvent = taskSyncContext.buildRebalanceAnswerTaskSyncEvent();
        Assertions.assertEquals((Object)"task0", (Object)syncEvent.getTaskUid());
        Assertions.assertEquals((int)1, (int)syncEvent.getTaskStates().size());
        Assertions.assertEquals((Object)MessageTypeEnum.REBALANCE_ANSWER, (Object)syncEvent.getMessageType());
        TaskState taskState1 = (TaskState)syncEvent.getTaskStates().get(syncEvent.getTaskUid());
        Assertions.assertEquals((int)taskState1.getPartitionsMap().size(), (int)4);
        Assertions.assertEquals((int)taskState1.getSharedPartitions().size(), (int)2);
        syncEvent = taskSyncContext.buildCurrentTaskSyncEvent();
        Assertions.assertEquals((Object)"task0", (Object)syncEvent.getTaskUid());
        Assertions.assertEquals((int)1, (int)syncEvent.getTaskStates().size());
        Assertions.assertEquals((Object)MessageTypeEnum.REGULAR, (Object)syncEvent.getMessageType());
        taskState1 = (TaskState)syncEvent.getTaskStates().get(syncEvent.getTaskUid());
        Assertions.assertEquals((int)taskState1.getPartitionsMap().size(), (int)4);
        Assertions.assertEquals((int)taskState1.getSharedPartitions().size(), (int)2);
        syncEvent = taskSyncContext.buildUpdateEpochTaskSyncEvent();
        Assertions.assertEquals((Object)"task0", (Object)syncEvent.getTaskUid());
        Assertions.assertEquals((int)3, (int)syncEvent.getTaskStates().size());
        Assertions.assertEquals((Object)MessageTypeEnum.UPDATE_EPOCH, (Object)syncEvent.getMessageType());
        taskState1 = (TaskState)syncEvent.getTaskStates().get(syncEvent.getTaskUid());
        Assertions.assertEquals((int)taskState1.getPartitionsMap().size(), (int)4);
        Assertions.assertEquals((int)taskState1.getSharedPartitions().size(), (int)2);
        TaskState taskState2 = (TaskState)syncEvent.getTaskStates().get("task1");
        Assertions.assertEquals((int)taskState2.getPartitionsMap().size(), (int)2);
        Assertions.assertEquals((int)taskState2.getSharedPartitions().size(), (int)1);
        TaskState taskState3 = (TaskState)syncEvent.getTaskStates().get("task2");
        Assertions.assertEquals((int)taskState3.getPartitionsMap().size(), (int)2);
        Assertions.assertEquals((int)taskState3.getSharedPartitions().size(), (int)1);
        syncEvent = taskSyncContext.buildNewEpochTaskSyncEvent();
        Assertions.assertEquals((Object)"task0", (Object)syncEvent.getTaskUid());
        Assertions.assertEquals((int)3, (int)syncEvent.getTaskStates().size());
        Assertions.assertEquals((Object)MessageTypeEnum.NEW_EPOCH, (Object)syncEvent.getMessageType());
        taskState1 = (TaskState)syncEvent.getTaskStates().get(syncEvent.getTaskUid());
        Assertions.assertEquals((int)taskState1.getPartitionsMap().size(), (int)4);
        Assertions.assertEquals((int)taskState1.getSharedPartitions().size(), (int)2);
        taskState2 = (TaskState)syncEvent.getTaskStates().get("task1");
        Assertions.assertEquals((int)taskState2.getPartitionsMap().size(), (int)2);
        Assertions.assertEquals((int)taskState2.getSharedPartitions().size(), (int)1);
        taskState3 = (TaskState)syncEvent.getTaskStates().get("task2");
        Assertions.assertEquals((int)taskState3.getPartitionsMap().size(), (int)2);
        Assertions.assertEquals((int)taskState3.getSharedPartitions().size(), (int)1);
    }

    private TaskSyncContext buildEmptyTaskSyncContext() {
        return TaskSyncContext.builder().taskUid("task0").currentTaskState(TaskState.builder().taskUid("task0").partitions(List.of()).sharedPartitions(List.of()).build()).taskStates(Map.of("task1", TaskState.builder().taskUid("task1").partitions(List.of()).sharedPartitions(List.of()).build(), "task2", TaskState.builder().taskUid("task2").partitions(List.of()).sharedPartitions(List.of()).build())).build();
    }

    private TaskSyncContext buildTaskSyncContextWithPartitions() {
        TaskState task0 = TaskTestHelper.generateTaskStateWithPartitions("task0", List.of(PartitionState.builder().token("token0").state(PartitionStateEnum.CREATED).build(), PartitionState.builder().token("token1").state(PartitionStateEnum.REMOVED).build(), PartitionState.builder().token("token2").state(PartitionStateEnum.RUNNING).build(), PartitionState.builder().token("token3").state(PartitionStateEnum.FINISHED).build()), List.of(PartitionState.builder().token("token4").state(PartitionStateEnum.CREATED).build(), PartitionState.builder().token("token5").state(PartitionStateEnum.REMOVED).build()));
        TaskState task1 = TaskTestHelper.generateTaskStateWithPartitions("task1", List.of(PartitionState.builder().token("token6").state(PartitionStateEnum.REMOVED).build(), PartitionState.builder().token("token7").state(PartitionStateEnum.FINISHED).build()), List.of(PartitionState.builder().token("token8").state(PartitionStateEnum.CREATED).build()));
        TaskState task2 = TaskTestHelper.generateTaskStateWithPartitions("task2", List.of(PartitionState.builder().token("token1").state(PartitionStateEnum.CREATED).build(), PartitionState.builder().token("token2").state(PartitionStateEnum.REMOVED).build()), List.of(PartitionState.builder().token("token3").state(PartitionStateEnum.RUNNING).build()));
        return TaskSyncContext.builder().taskUid("task0").currentTaskState(task0).taskStates(Map.of("task1", task1, "task2", task2)).build();
    }
}

