/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.SyncEventMerger;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.TaskTestHelper;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SyncEventMergerTest {
    SyncEventMergerTest() {
    }

    @Test
    void testMergeRebalanceAnswer() {
        TaskSyncContext taskSyncContext1 = this.buildTaskSyncContext1();
        TaskSyncContext taskSyncContext2 = this.buildTaskSyncContext2();
        TaskSyncEvent rebalanceAnswer1 = taskSyncContext1.buildRebalanceAnswerTaskSyncEvent();
        TaskSyncContext mergedRebalanceAnswer = SyncEventMerger.mergeRebalanceAnswer((TaskSyncContext)taskSyncContext2, (TaskSyncEvent)rebalanceAnswer1);
        Assertions.assertEquals((Object)"task2", (Object)mergedRebalanceAnswer.getTaskUid());
        Assertions.assertEquals((int)2, (int)mergedRebalanceAnswer.getTaskStates().size());
        TaskState taskState1 = (TaskState)mergedRebalanceAnswer.getTaskStates().get("task0");
        Assertions.assertEquals((Object)taskState1.getTaskUid(), (Object)"task0");
        Assertions.assertEquals((int)taskState1.getPartitionsMap().size(), (int)4);
        PartitionState partition1 = (PartitionState)taskState1.getPartitionsMap().get("token0");
        Assertions.assertEquals((Object)partition1.getState(), (Object)PartitionStateEnum.CREATED);
        PartitionState partition2 = (PartitionState)taskState1.getPartitionsMap().get("token1");
        Assertions.assertEquals((Object)partition2.getState(), (Object)PartitionStateEnum.REMOVED);
        PartitionState partition3 = (PartitionState)taskState1.getPartitionsMap().get("token2");
        Assertions.assertEquals((Object)partition3.getState(), (Object)PartitionStateEnum.RUNNING);
        PartitionState partition4 = (PartitionState)taskState1.getPartitionsMap().get("token3");
        Assertions.assertEquals((Object)partition4.getState(), (Object)PartitionStateEnum.FINISHED);
        Assertions.assertEquals((int)taskState1.getSharedPartitions().size(), (int)2);
        PartitionState partition5 = (PartitionState)taskState1.getSharedPartitionsMap().get("token4");
        Assertions.assertEquals((Object)partition5.getState(), (Object)PartitionStateEnum.CREATED);
        PartitionState partition6 = (PartitionState)taskState1.getSharedPartitionsMap().get("token5");
        Assertions.assertEquals((Object)partition6.getState(), (Object)PartitionStateEnum.REMOVED);
        TaskState taskState2 = mergedRebalanceAnswer.getCurrentTaskState();
        Assertions.assertEquals((Object)taskState2.getTaskUid(), (Object)"task2");
        Assertions.assertEquals((int)taskState2.getPartitionsMap().size(), (int)4);
        Assertions.assertEquals((int)taskState2.getSharedPartitionsMap().size(), (int)1);
        TaskState taskState3 = (TaskState)mergedRebalanceAnswer.getTaskStates().get("task1");
        Assertions.assertEquals((Object)taskState3.getTaskUid(), (Object)"task1");
        Assertions.assertEquals((int)taskState3.getPartitionsMap().size(), (int)2);
        Assertions.assertEquals((int)taskState3.getSharedPartitionsMap().size(), (int)1);
    }

    void testMergeIncrementalAnswer() {
        TaskSyncContext taskSyncContext1 = this.buildTaskSyncContext1();
        TaskSyncContext taskSyncContext2 = this.buildTaskSyncContext2();
        TaskSyncEvent incrementalAnswer1 = taskSyncContext1.buildCurrentTaskSyncEvent();
        TaskSyncContext mergeIncrementalAnswer = SyncEventMerger.mergeIncrementalTaskSyncEvent((TaskSyncContext)taskSyncContext2, (TaskSyncEvent)incrementalAnswer1);
        Assertions.assertEquals((Object)"task2", (Object)mergeIncrementalAnswer.getTaskUid());
        Assertions.assertEquals((int)2, (int)mergeIncrementalAnswer.getTaskStates().size());
        TaskState taskState1 = (TaskState)mergeIncrementalAnswer.getTaskStates().get("task0");
        Assertions.assertEquals((Object)taskState1.getTaskUid(), (Object)"task0");
        Assertions.assertEquals((int)taskState1.getPartitionsMap().size(), (int)4);
        PartitionState partition1 = (PartitionState)taskState1.getPartitionsMap().get("token0");
        Assertions.assertEquals((Object)partition1.getState(), (Object)PartitionStateEnum.CREATED);
        PartitionState partition2 = (PartitionState)taskState1.getPartitionsMap().get("token1");
        Assertions.assertEquals((Object)partition2.getState(), (Object)PartitionStateEnum.REMOVED);
        PartitionState partition3 = (PartitionState)taskState1.getPartitionsMap().get("token2");
        Assertions.assertEquals((Object)partition3.getState(), (Object)PartitionStateEnum.RUNNING);
        PartitionState partition4 = (PartitionState)taskState1.getPartitionsMap().get("token3");
        Assertions.assertEquals((Object)partition4.getState(), (Object)PartitionStateEnum.FINISHED);
        Assertions.assertEquals((int)taskState1.getSharedPartitions().size(), (int)2);
        PartitionState partition5 = (PartitionState)taskState1.getSharedPartitionsMap().get("token4");
        Assertions.assertEquals((Object)partition5.getState(), (Object)PartitionStateEnum.CREATED);
        PartitionState partition6 = (PartitionState)taskState1.getSharedPartitionsMap().get("token5");
        Assertions.assertEquals((Object)partition6.getState(), (Object)PartitionStateEnum.REMOVED);
        TaskState taskState2 = mergeIncrementalAnswer.getCurrentTaskState();
        Assertions.assertEquals((Object)taskState2.getTaskUid(), (Object)"task2");
        Assertions.assertEquals((int)taskState2.getPartitionsMap().size(), (int)4);
        Assertions.assertEquals((int)taskState2.getSharedPartitionsMap().size(), (int)1);
        TaskState taskState3 = (TaskState)mergeIncrementalAnswer.getTaskStates().get("task1");
        Assertions.assertEquals((Object)taskState3.getTaskUid(), (Object)"task1");
        Assertions.assertEquals((int)taskState3.getPartitionsMap().size(), (int)2);
        Assertions.assertEquals((int)taskState3.getSharedPartitionsMap().size(), (int)1);
    }

    @Test
    void testMergeNewEpoch() {
        TaskSyncContext taskSyncContext1 = this.buildTaskSyncContext1();
        TaskSyncContext taskSyncContext2 = this.buildTaskSyncContext2();
        TaskSyncEvent syncEvent = taskSyncContext1.buildNewEpochTaskSyncEvent();
        TaskSyncContext mergeNewEpoch = SyncEventMerger.mergeNewEpoch((TaskSyncContext)taskSyncContext2, (TaskSyncEvent)syncEvent);
        Assertions.assertEquals((Object)"task2", (Object)mergeNewEpoch.getTaskUid());
        Assertions.assertEquals((int)2, (int)mergeNewEpoch.getTaskStates().size());
        Assertions.assertEquals((Object)"task2", (Object)mergeNewEpoch.getTaskUid());
        Assertions.assertEquals((int)2, (int)mergeNewEpoch.getTaskStates().size());
        TaskState taskState1 = (TaskState)mergeNewEpoch.getTaskStates().get("task0");
        Assertions.assertEquals((Object)taskState1.getTaskUid(), (Object)"task0");
        Assertions.assertEquals((int)taskState1.getPartitionsMap().size(), (int)4);
        PartitionState partition1 = (PartitionState)taskState1.getPartitionsMap().get("token0");
        Assertions.assertEquals((Object)partition1.getState(), (Object)PartitionStateEnum.CREATED);
        PartitionState partition2 = (PartitionState)taskState1.getPartitionsMap().get("token1");
        Assertions.assertEquals((Object)partition2.getState(), (Object)PartitionStateEnum.REMOVED);
        PartitionState partition3 = (PartitionState)taskState1.getPartitionsMap().get("token2");
        Assertions.assertEquals((Object)partition3.getState(), (Object)PartitionStateEnum.RUNNING);
        PartitionState partition4 = (PartitionState)taskState1.getPartitionsMap().get("token3");
        Assertions.assertEquals((Object)partition4.getState(), (Object)PartitionStateEnum.FINISHED);
        Assertions.assertEquals((int)taskState1.getSharedPartitions().size(), (int)2);
        PartitionState partition5 = (PartitionState)taskState1.getSharedPartitionsMap().get("token4");
        Assertions.assertEquals((Object)partition5.getState(), (Object)PartitionStateEnum.CREATED);
        PartitionState partition6 = (PartitionState)taskState1.getSharedPartitionsMap().get("token5");
        Assertions.assertEquals((Object)partition6.getState(), (Object)PartitionStateEnum.REMOVED);
        TaskState taskState2 = mergeNewEpoch.getCurrentTaskState();
        Assertions.assertEquals((Object)taskState2.getTaskUid(), (Object)"task2");
        Assertions.assertEquals((int)taskState2.getPartitionsMap().size(), (int)4);
        Assertions.assertEquals((int)taskState2.getSharedPartitionsMap().size(), (int)1);
        TaskState taskState3 = (TaskState)mergeNewEpoch.getTaskStates().get("task1");
        Assertions.assertEquals((Object)taskState3.getTaskUid(), (Object)"task1");
        Assertions.assertEquals((int)taskState3.getPartitionsMap().size(), (int)1);
        Assertions.assertEquals((int)taskState3.getSharedPartitionsMap().size(), (int)1);
    }

    @Test
    void testMergeEpochupdate() {
        TaskSyncContext taskSyncContext1 = this.buildTaskSyncContext1();
        TaskSyncContext taskSyncContext2 = this.buildTaskSyncContext2();
        TaskSyncEvent syncEvent = taskSyncContext1.buildUpdateEpochTaskSyncEvent();
        TaskSyncContext mergedEpochUpdate = SyncEventMerger.mergeEpochUpdate((TaskSyncContext)taskSyncContext2, (TaskSyncEvent)syncEvent);
        Assertions.assertEquals((Object)"task2", (Object)mergedEpochUpdate.getTaskUid());
        Assertions.assertEquals((int)2, (int)mergedEpochUpdate.getTaskStates().size());
        Assertions.assertEquals((Object)"task2", (Object)mergedEpochUpdate.getTaskUid());
        Assertions.assertEquals((int)2, (int)mergedEpochUpdate.getTaskStates().size());
        TaskState taskState1 = (TaskState)mergedEpochUpdate.getTaskStates().get("task0");
        Assertions.assertEquals((Object)taskState1.getTaskUid(), (Object)"task0");
        Assertions.assertEquals((int)taskState1.getPartitionsMap().size(), (int)4);
        PartitionState partition1 = (PartitionState)taskState1.getPartitionsMap().get("token0");
        Assertions.assertEquals((Object)partition1.getState(), (Object)PartitionStateEnum.CREATED);
        PartitionState partition2 = (PartitionState)taskState1.getPartitionsMap().get("token1");
        Assertions.assertEquals((Object)partition2.getState(), (Object)PartitionStateEnum.REMOVED);
        PartitionState partition3 = (PartitionState)taskState1.getPartitionsMap().get("token2");
        Assertions.assertEquals((Object)partition3.getState(), (Object)PartitionStateEnum.RUNNING);
        PartitionState partition4 = (PartitionState)taskState1.getPartitionsMap().get("token3");
        Assertions.assertEquals((Object)partition4.getState(), (Object)PartitionStateEnum.FINISHED);
        Assertions.assertEquals((int)taskState1.getSharedPartitions().size(), (int)2);
        PartitionState partition5 = (PartitionState)taskState1.getSharedPartitionsMap().get("token4");
        Assertions.assertEquals((Object)partition5.getState(), (Object)PartitionStateEnum.CREATED);
        PartitionState partition6 = (PartitionState)taskState1.getSharedPartitionsMap().get("token5");
        Assertions.assertEquals((Object)partition6.getState(), (Object)PartitionStateEnum.REMOVED);
        TaskState taskState2 = mergedEpochUpdate.getCurrentTaskState();
        Assertions.assertEquals((Object)taskState2.getTaskUid(), (Object)"task2");
        Assertions.assertEquals((int)taskState2.getPartitionsMap().size(), (int)4);
        Assertions.assertEquals((int)taskState2.getSharedPartitionsMap().size(), (int)1);
        TaskState taskState3 = (TaskState)mergedEpochUpdate.getTaskStates().get("task1");
        Assertions.assertEquals((Object)taskState3.getTaskUid(), (Object)"task1");
        Assertions.assertEquals((int)taskState3.getPartitionsMap().size(), (int)2);
        Assertions.assertEquals((int)taskState3.getSharedPartitionsMap().size(), (int)1);
    }

    private TaskSyncContext buildTaskSyncContext1() {
        TaskState task0 = TaskTestHelper.generateTaskStateWithPartitions("task0", List.of(PartitionState.builder().token("token0").state(PartitionStateEnum.CREATED).build(), PartitionState.builder().token("token1").state(PartitionStateEnum.REMOVED).build(), PartitionState.builder().token("token2").state(PartitionStateEnum.RUNNING).build(), PartitionState.builder().token("token3").state(PartitionStateEnum.FINISHED).build()), List.of(PartitionState.builder().token("token4").state(PartitionStateEnum.CREATED).build(), PartitionState.builder().token("token5").state(PartitionStateEnum.REMOVED).build()));
        TaskState task1 = TaskTestHelper.generateTaskStateWithPartitions("task1", List.of(PartitionState.builder().token("token6").state(PartitionStateEnum.REMOVED).build()), List.of(PartitionState.builder().token("token8").state(PartitionStateEnum.CREATED).build()));
        TaskState task2 = TaskTestHelper.generateTaskStateWithPartitions("task2", List.of(PartitionState.builder().token("token10").state(PartitionStateEnum.RUNNING).build()), List.of(PartitionState.builder().token("token14").state(PartitionStateEnum.CREATED).build()));
        return TaskSyncContext.builder().taskUid("task0").currentTaskState(task0).taskStates(Map.of("task1", task1, "task2", task2)).build();
    }

    private TaskSyncContext buildTaskSyncContext2() {
        TaskState task0 = TaskTestHelper.generateTaskStateWithPartitions("task0", List.of(PartitionState.builder().token("token0").state(PartitionStateEnum.CREATED).build()), List.of(PartitionState.builder().token("token4").state(PartitionStateEnum.CREATED).build()));
        TaskState task1 = TaskTestHelper.generateTaskStateWithPartitions("task1", List.of(PartitionState.builder().token("token6").state(PartitionStateEnum.REMOVED).build(), PartitionState.builder().token("token7").state(PartitionStateEnum.FINISHED).build()), List.of(PartitionState.builder().token("token8").state(PartitionStateEnum.CREATED).build()));
        TaskState task2 = TaskTestHelper.generateTaskStateWithPartitions("task2", List.of(PartitionState.builder().token("token9").state(PartitionStateEnum.CREATED).build(), PartitionState.builder().token("token10").state(PartitionStateEnum.RUNNING).build(), PartitionState.builder().token("token11").state(PartitionStateEnum.REMOVED).build(), PartitionState.builder().token("token12").state(PartitionStateEnum.FINISHED).build()), List.of(PartitionState.builder().token("token14").state(PartitionStateEnum.CREATED).build()));
        return TaskSyncContext.builder().taskUid("task2").currentTaskState(task2).taskStates(Map.of("task1", task1, "task0", task0)).build();
    }
}

