/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.StreamEventQueue;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.db.model.event.ChangeStreamEvent;
import io.debezium.connector.spanner.db.model.event.FinishPartitionEvent;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.MetricEvent;
import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class StreamEventQueueTest {
    StreamEventQueueTest() {
    }

    @Test
    void testStreamEventQueue() throws InterruptedException {
        MetricsEventPublisher metricsEventPublisher = (MetricsEventPublisher)Mockito.mock(MetricsEventPublisher.class);
        ((MetricsEventPublisher)Mockito.doNothing().when((Object)metricsEventPublisher)).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
        StreamEventQueue streamEventQueue = new StreamEventQueue(3, metricsEventPublisher);
        HashSet parentTokens = new HashSet();
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
        FinishPartitionEvent partitionEvent = new FinishPartitionEvent(new Partition("token", parentTokens, startTimestamp, Timestamp.ofTimeMicroseconds((long)1L), "parentToken"));
        streamEventQueue.put((ChangeStreamEvent)partitionEvent);
        ChangeStreamEvent takeEvent = streamEventQueue.take();
        Assertions.assertSame((Object)partitionEvent, (Object)takeEvent);
        ((MetricsEventPublisher)Mockito.verify((Object)metricsEventPublisher, (VerificationMode)Mockito.times((int)3))).publishMetricEvent((MetricEvent)ArgumentMatchers.any());
    }
}

