/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.SpannerConnector;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerConnectorTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SpannerConnectorTest {
    SpannerConnectorTest() {
    }

    @Test
    void testVersion() {
        Assertions.assertNotNull((Object)new SpannerConnector().version());
    }

    @Test
    void testTaskClass() {
        Class actualTaskClassResult = new SpannerConnector().taskClass();
        Assertions.assertSame(SpannerConnectorTask.class, (Object)actualTaskClassResult);
    }

    @Test
    void testStart() {
        SpannerConnector spannerConnector = (SpannerConnector)Mockito.spy((Object)new SpannerConnector());
        ((SpannerConnector)Mockito.doNothing().when((Object)spannerConnector)).createInternalTopics((SpannerConnectorConfig)ArgumentMatchers.any());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "connector");
        spannerConnector.start(props);
        Assertions.assertEquals((int)2, (int)spannerConnector.getProps(1).size());
    }

    @Test
    void testStop() {
        SpannerConnector spannerConnector = (SpannerConnector)Mockito.spy((Object)new SpannerConnector());
        ((SpannerConnector)Mockito.doNothing().when((Object)spannerConnector)).createInternalTopics((SpannerConnectorConfig)ArgumentMatchers.any());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "connector");
        spannerConnector.start(props);
        spannerConnector.stop();
        Assertions.assertThrows(NullPointerException.class, () -> spannerConnector.getProps(1));
    }

    @Test
    void testTaskConfigs() {
        SpannerConnector spannerConnector = (SpannerConnector)Mockito.spy((Object)new SpannerConnector());
        ((SpannerConnector)Mockito.doNothing().when((Object)spannerConnector)).createInternalTopics((SpannerConnectorConfig)ArgumentMatchers.any());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "connector");
        spannerConnector.start(props);
        List maps = spannerConnector.taskConfigs(3);
        Assertions.assertEquals((int)10, (int)maps.size());
    }

    @Test
    @Disabled
    void testValidate() {
        SpannerConnector spannerConnector = new SpannerConnector();
        List configValuesResult = spannerConnector.validate(new HashMap()).configValues();
        Assertions.assertEquals((int)45, (int)configValuesResult.size());
        ConfigValue getResult = (ConfigValue)configValuesResult.get(43);
        Assertions.assertTrue((boolean)getResult.visible());
        ConfigValue getResult1 = (ConfigValue)configValuesResult.get(3);
        Assertions.assertTrue((boolean)getResult1.visible());
        Assertions.assertNull((Object)getResult1.value());
        List recommendedValuesResult = getResult1.recommendedValues();
        Assertions.assertTrue((boolean)recommendedValuesResult.isEmpty());
        Assertions.assertEquals((Object)"query.fetch.size", (Object)getResult1.name());
        List errorMessagesResult = getResult1.errorMessages();
        Assertions.assertEquals((Object)recommendedValuesResult, (Object)errorMessagesResult);
        Assertions.assertNull((Object)getResult.value());
        List recommendedValuesResult1 = getResult.recommendedValues();
        Assertions.assertEquals((Object)errorMessagesResult, (Object)recommendedValuesResult1);
        Assertions.assertEquals((Object)"gcp.spanner.database.id", (Object)getResult.name());
        List errorMessagesResult1 = getResult.errorMessages();
        Assertions.assertEquals((int)1, (int)errorMessagesResult1.size());
        Assertions.assertEquals((Object)"The 'gcp.spanner.database.id' value is invalid: The field is not specified", errorMessagesResult1.get(0));
        ConfigValue getResult2 = (ConfigValue)configValuesResult.get(42);
        Assertions.assertNull((Object)getResult2.value());
        List recommendedValuesResult2 = getResult2.recommendedValues();
        Assertions.assertEquals((Object)recommendedValuesResult1, (Object)recommendedValuesResult2);
        Assertions.assertEquals((Object)"connector.spanner.rebalancing.commit.offsets.timeout", (Object)getResult2.name());
        List errorMessagesResult2 = getResult2.errorMessages();
        Assertions.assertEquals((Object)recommendedValuesResult2, (Object)errorMessagesResult2);
        ConfigValue getResult3 = (ConfigValue)configValuesResult.get(2);
        Assertions.assertNull((Object)getResult3.value());
        List recommendedValuesResult3 = getResult3.recommendedValues();
        Assertions.assertEquals((Object)errorMessagesResult2, (Object)recommendedValuesResult3);
        Assertions.assertEquals((Object)"max.queue.size", (Object)getResult3.name());
        List errorMessagesResult3 = getResult3.errorMessages();
        Assertions.assertEquals((Object)recommendedValuesResult3, (Object)errorMessagesResult3);
        ConfigValue getResult4 = (ConfigValue)configValuesResult.get(44);
        Assertions.assertNull((Object)getResult4.value());
        List recommendedValuesResult4 = getResult4.recommendedValues();
        Assertions.assertEquals((Object)errorMessagesResult3, (Object)recommendedValuesResult4);
        Assertions.assertEquals((Object)"connector.spanner.sync.delivery.timeout.ms", (Object)getResult4.name());
        List errorMessagesResult4 = getResult4.errorMessages();
        Assertions.assertEquals((Object)recommendedValuesResult4, (Object)errorMessagesResult4);
        ConfigValue getResult5 = (ConfigValue)configValuesResult.get(0);
        Assertions.assertNull((Object)getResult5.value());
        List recommendedValuesResult5 = getResult5.recommendedValues();
        Assertions.assertEquals((Object)errorMessagesResult4, (Object)recommendedValuesResult5);
        Assertions.assertEquals((Object)"gcp.spanner.credentials.path", (Object)getResult5.name());
        Assertions.assertEquals((Object)recommendedValuesResult5, (Object)getResult5.errorMessages());
        Assertions.assertTrue((boolean)getResult4.visible());
        Assertions.assertTrue((boolean)getResult5.visible());
        Assertions.assertTrue((boolean)getResult2.visible());
        Assertions.assertTrue((boolean)getResult3.visible());
    }

    @Test
    void testConfig() {
        ConfigDef actualConfigResult = new SpannerConnector().config();
        Map configKeysResult = actualConfigResult.configKeys();
        Assertions.assertEquals((int)56, (int)configKeysResult.size());
        List groupsResult = actualConfigResult.groups();
        Assertions.assertEquals((int)3, (int)groupsResult.size());
        Assertions.assertEquals((Object)"Spanner", groupsResult.get(0));
        Assertions.assertEquals((Object)"Connector", groupsResult.get(1));
        Assertions.assertEquals((Object)"Events", groupsResult.get(2));
        ConfigDef.ConfigKey getResult = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.change.stream");
        Assertions.assertEquals((Object)ConfigDef.Width.MEDIUM, (Object)getResult.width);
        ConfigDef.ConfigKey getResult1 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.instance.id");
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult1.width);
        Assertions.assertNull((Object)getResult1.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult1.type);
        Assertions.assertNull((Object)getResult1.recommender);
        Assertions.assertEquals((int)1, (int)getResult1.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.instance.id", (Object)getResult1.name);
        Assertions.assertFalse((boolean)getResult1.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResult1.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult1.group);
        Assertions.assertEquals((Object)"Spanner instance id", (Object)getResult1.documentation);
        Assertions.assertEquals((Object)"InstanceId", (Object)getResult1.displayName);
        Assertions.assertTrue((boolean)getResult1.dependents.isEmpty());
        Assertions.assertNull((Object)getResult1.defaultValue);
        Assertions.assertNull((Object)getResult.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult.type);
        Assertions.assertNull((Object)getResult.recommender);
        Assertions.assertEquals((int)4, (int)getResult.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.change.stream", (Object)getResult.name);
        Assertions.assertFalse((boolean)getResult.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResult.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult.group);
        Assertions.assertEquals((Object)"Spanner change stream name", (Object)getResult.documentation);
        Assertions.assertEquals((Object)"Change stream name", (Object)getResult.displayName);
        Assertions.assertNull((Object)getResult.defaultValue);
        ConfigDef.ConfigKey getResultDBRole = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.database.role");
        Assertions.assertNull((Object)getResultDBRole.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResultDBRole.type);
        Assertions.assertNull((Object)getResultDBRole.recommender);
        Assertions.assertEquals((int)3, (int)getResultDBRole.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.database.role", (Object)getResultDBRole.name);
        Assertions.assertFalse((boolean)getResultDBRole.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResultDBRole.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResultDBRole.group);
        Assertions.assertEquals((Object)"Spanner database role", (Object)getResultDBRole.documentation);
        Assertions.assertEquals((Object)"DatabaseRole", (Object)getResultDBRole.displayName);
        Assertions.assertNull((Object)getResultDBRole.defaultValue);
        ConfigDef.ConfigKey getResult2 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.database.id");
        Assertions.assertNull((Object)getResult2.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult2.type);
        Assertions.assertNull((Object)getResult2.recommender);
        Assertions.assertEquals((int)2, (int)getResult2.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.database.id", (Object)getResult2.name);
        Assertions.assertFalse((boolean)getResult2.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResult2.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult2.group);
        Assertions.assertEquals((Object)"Spanner database id", (Object)getResult2.documentation);
        Assertions.assertEquals((Object)"DatabaseId", (Object)getResult2.displayName);
        Assertions.assertNull((Object)getResult2.defaultValue);
        ConfigDef.ConfigKey getResult3 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.project.id");
        Assertions.assertNull((Object)getResult3.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult3.type);
        Assertions.assertNull((Object)getResult3.recommender);
        Assertions.assertEquals((int)1, (int)getResult3.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.project.id", (Object)getResult3.name);
        Assertions.assertFalse((boolean)getResult3.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResult3.importance);
        Assertions.assertEquals((Object)"Spanner", (Object)getResult3.group);
        Assertions.assertEquals((Object)"Spanner project id", (Object)getResult3.documentation);
        Assertions.assertEquals((Object)"ProjectId", (Object)getResult3.displayName);
        Assertions.assertNull((Object)getResult3.defaultValue);
        ConfigDef.ConfigKey getResult4 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.start.time");
        Assertions.assertNull((Object)getResult4.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult4.type);
        Assertions.assertNull((Object)getResult4.recommender);
        Assertions.assertEquals((int)5, (int)getResult4.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.start.time", (Object)getResult4.name);
        Assertions.assertFalse((boolean)getResult4.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.MEDIUM, (Object)getResult4.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult4.group);
        Assertions.assertEquals((Object)"Start change stream time", (Object)getResult4.documentation);
        Assertions.assertEquals((Object)"Start time", (Object)getResult4.displayName);
        Assertions.assertNull((Object)getResult4.defaultValue);
        ConfigDef.ConfigKey getResult5 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.end.time");
        Assertions.assertNull((Object)getResult5.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult5.type);
        Assertions.assertNull((Object)getResult5.recommender);
        Assertions.assertEquals((int)6, (int)getResult5.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.end.time", (Object)getResult5.name);
        Assertions.assertFalse((boolean)getResult5.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.MEDIUM, (Object)getResult5.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult5.group);
        Assertions.assertEquals((Object)"End change stream time", (Object)getResult5.documentation);
        Assertions.assertEquals((Object)"End time", (Object)getResult5.displayName);
        Assertions.assertNull((Object)getResult5.defaultValue);
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult4.width);
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult5.width);
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult2.width);
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult3.width);
    }
}

