/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.leader;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.RebalanceMetricEvent;
import io.debezium.connector.spanner.task.PartitionFactory;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import io.debezium.connector.spanner.task.state.NewPartitionsEvent;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import io.debezium.connector.spanner.task.utils.TimeoutMeter;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ErrorHandler;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderService.class);
    private static final int POLL_INTERVAL_MILLIS = 500;
    private static final Duration AWAIT_TASK_ANSWER_DURATION = Duration.of(60L, ChronoUnit.SECONDS);
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final Timestamp startTime;
    private final Timestamp endTime;
    private final BlockingConsumer<TaskStateChangeEvent> eventConsumer;
    private final ErrorHandler errorHandler;
    private final MetricsEventPublisher metricsEventPublisher;
    private final PartitionFactory partitionFactory;
    private final Duration awaitTaskAnswerDuration;

    public LeaderService(TaskSyncContextHolder taskSyncContextHolder, SpannerConnectorConfig spannerConnectorConfig, BlockingConsumer<TaskStateChangeEvent> eventConsumer, ErrorHandler errorHandler, PartitionFactory partitionFactory, MetricsEventPublisher metricsEventPublisher) {
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.startTime = spannerConnectorConfig.startTime();
        this.endTime = spannerConnectorConfig.endTime() != null ? spannerConnectorConfig.endTime() : null;
        this.awaitTaskAnswerDuration = spannerConnectorConfig.getAwaitTaskAnswerTimeout();
        this.eventConsumer = eventConsumer;
        this.errorHandler = errorHandler;
        this.partitionFactory = partitionFactory;
        this.metricsEventPublisher = metricsEventPublisher;
    }

    public boolean isStartFromScratch() {
        EnumSet<PartitionStateEnum> inProgressStates = EnumSet.of(PartitionStateEnum.CREATED, PartitionStateEnum.READY_FOR_STREAMING, PartitionStateEnum.SCHEDULED, PartitionStateEnum.RUNNING);
        Map<String, TaskState> allTaskStates = this.taskSyncContextHolder.get().getAllTaskStates();
        boolean anyInProgress = allTaskStates.values().stream().flatMap(t -> Stream.of(t.getPartitions(), t.getSharedPartitions()).flatMap(Collection::stream)).anyMatch(p -> inProgressStates.contains((Object)p.getState()));
        return !anyInProgress;
    }

    public Map<String, String> awaitAllNewTaskStateUpdates(Set<String> consumers, long rebalanceGenerationId) throws InterruptedException {
        HashMap<String, String> consumerToTaskMap = new HashMap<String, String>();
        LOGGER.info("awaitAllNewTaskStateUpdates: wait taskSyncContextHolder for all new task updates");
        TimeoutMeter timeoutMeter = TimeoutMeter.setTimeout(this.awaitTaskAnswerDuration);
        while (consumerToTaskMap.size() < consumers.size()) {
            LOGGER.info("Task {}, rebalance generation ID {}, awaitAllNewTaskStateUpdates: expected: {}, actual: {}. Expected consumers: {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), this.taskSyncContextHolder.get().getRebalanceGenerationId(), consumers.size(), consumerToTaskMap.size(), consumers});
            if (timeoutMeter.isExpired()) {
                LOGGER.error("Task {} : Not received all answers from tasks", (Object)this.taskSyncContextHolder.get().getTaskUid());
                break;
            }
            Thread.sleep(500L);
            this.taskSyncContextHolder.get().getAllTaskStates().entrySet().stream().filter(e -> !consumerToTaskMap.containsValue(e.getKey()) && consumers.contains(((TaskState)e.getValue()).getConsumerId()) && ((TaskState)e.getValue()).getRebalanceGenerationId() == rebalanceGenerationId).findAny().ifPresent(state -> consumerToTaskMap.put(((TaskState)state.getValue()).getConsumerId(), (String)state.getKey()));
            this.metricsEventPublisher.publishMetricEvent(new RebalanceMetricEvent(consumerToTaskMap.size(), consumers.size()));
        }
        LOGGER.info("awaitAllNewTaskStateUpdates: expected: {}, actual: {}. Expected consumers: {}", new Object[]{consumers.size(), consumerToTaskMap.size(), consumers});
        LOGGER.info("awaitAllNewTaskStateUpdates: new task updated the state with {} consumers: {}", consumerToTaskMap, (Object)consumerToTaskMap.size());
        return consumerToTaskMap;
    }

    public void newParentPartition() throws InterruptedException {
        Partition partition = this.partitionFactory.initPartition(this.startTime, this.endTime);
        LOGGER.info("New parent partition {}", (Object)partition);
        this.eventConsumer.accept((Object)new NewPartitionsEvent(List.of(partition)));
    }
}

