/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.TaskSyncPublisher;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceState;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.LoggerUtils;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import io.debezium.connector.spanner.task.leader.LeaderAction;
import io.debezium.connector.spanner.task.leader.LowWatermarkStampPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebalanceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RebalanceHandler.class);
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final TaskSyncPublisher taskSyncPublisher;
    private final LeaderAction leaderAction;
    private final LowWatermarkStampPublisher lowWatermarkStampPublisher;

    public RebalanceHandler(TaskSyncContextHolder taskSyncContextHolder, TaskSyncPublisher taskSyncPublisher, LeaderAction leaderAction, LowWatermarkStampPublisher lowWatermarkStampPublisher) {
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.taskSyncPublisher = taskSyncPublisher;
        this.leaderAction = leaderAction;
        this.lowWatermarkStampPublisher = lowWatermarkStampPublisher;
    }

    public void process(boolean isLeader, String consumerId, long rebalanceGenerationId) throws InterruptedException {
        LOGGER.info("processRebalancingEvent: start, consumerId: {}, taskId{}, rebalanceGenerationId: {}, isLeader {}", new Object[]{consumerId, this.taskSyncContextHolder.get().getTaskUid(), rebalanceGenerationId, isLeader});
        this.leaderAction.stop();
        LOGGER.info("processRebalancingEvent: stopped leader thread, consumerId: {}, taskId{}, rebalanceGenerationId: {}, isLeader {}", new Object[]{consumerId, this.taskSyncContextHolder.get().getTaskUid(), rebalanceGenerationId, isLeader});
        TaskSyncContext context = this.taskSyncContextHolder.updateAndGet(oldContext -> {
            if (rebalanceGenerationId < this.taskSyncContextHolder.get().getRebalanceGenerationId()) {
                LOGGER.info("processRebalancingEvent: skipping due to stale rebalance generation ID {}, consumerId: {}, taskId{}, rebalanceGenerationId: {}, isLeader {}", new Object[]{rebalanceGenerationId, consumerId, this.taskSyncContextHolder.get().getTaskUid(), rebalanceGenerationId, isLeader});
                return oldContext;
            }
            TaskState updatedState = oldContext.getCurrentTaskState().toBuilder().consumerId(consumerId).rebalanceGenerationId(rebalanceGenerationId).build();
            return oldContext.toBuilder().consumerId(consumerId).rebalanceGenerationId(rebalanceGenerationId).currentTaskState(updatedState).isLeader(isLeader).rebalanceState(RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED).build();
        });
        if (context.getRebalanceGenerationId() != rebalanceGenerationId) {
            LOGGER.info("processRebalancingEvent: failed to update task sync context, consumerId: {}, taskId{}, rebalanceGenerationId: {}, isLeader {}, task rebalance generation ID {}", new Object[]{consumerId, this.taskSyncContextHolder.get().getTaskUid(), rebalanceGenerationId, isLeader, this.taskSyncContextHolder.get().getRebalanceGenerationId()});
            return;
        }
        TaskSyncEvent taskSyncEvent = context.buildRebalanceAnswerTaskSyncEvent();
        LoggerUtils.debug(LOGGER, "processRebalancingEvent: send: {}", taskSyncEvent);
        LOGGER.info("Task {} - RebalanceHandler sent sync event for consumer ID {} and rebalance generation ID {}", new Object[]{taskSyncEvent.getTaskUid(), consumerId, this.taskSyncContextHolder.get().getRebalanceGenerationId()});
        this.taskSyncPublisher.send(taskSyncEvent);
        LOGGER.info("processRebalancingEvent: Task {} rebalance answer has been sent for consumer ID {} and rebalance generation ID {}, num partitions {} num shared partitions {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), consumerId, this.taskSyncContextHolder.get().getRebalanceGenerationId(), this.taskSyncContextHolder.get().getNumPartitions(), this.taskSyncContextHolder.get().getNumSharedPartitions()});
        if (isLeader) {
            LOGGER.info("Task {} is leader", (Object)context.getTaskUid());
            this.leaderAction.start();
            this.lowWatermarkStampPublisher.start();
        } else {
            this.lowWatermarkStampPublisher.suspend();
        }
    }

    public void init() {
        this.lowWatermarkStampPublisher.init();
    }

    public synchronized void destroy() {
        this.leaderAction.stop();
        LOGGER.info("Task {}, destroyed leader action ", (Object)this.taskSyncContextHolder.get().getTaskUid());
        try {
            this.lowWatermarkStampPublisher.destroy();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOGGER.info("Task {}, destroyed low watermark stamp publisher ", (Object)this.taskSyncContextHolder.get().getTaskUid());
    }
}

