/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.stream;

import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionThreadPool.class);
    private final Map<String, Thread> threadMap = new HashMap<String, Thread>();
    private final Duration sleepInterval = Duration.ofMillis(100L);
    private final Clock clock = Clock.system();

    public synchronized boolean submit(String token, Runnable runnable) {
        if (this.threadMap.containsKey(token)) {
            LOGGER.info("Failed to submit token {} due to it existing in thread map {}", (Object)token, this.threadMap.keySet().stream().collect(Collectors.toList()));
            return false;
        }
        this.clean();
        Thread thread = new Thread(runnable, "SpannerConnector-PartitionThreadPool");
        this.threadMap.put(token, thread);
        thread.start();
        return true;
    }

    public synchronized void stop(String token) {
        this.clean();
        Thread thread = this.threadMap.get(token);
        if (thread != null) {
            LOGGER.info("Interrupting SpannerConnector-PartitionThreadPool");
            thread.interrupt();
        }
        this.threadMap.remove(token);
    }

    public synchronized void shutdown(String taskUid) {
        LOGGER.info("Trying to shut down partition thread pool for task {}", (Object)taskUid);
        this.clean();
        this.threadMap.values().forEach(Thread::interrupt);
        Metronome metronome = Metronome.sleeper((Duration)this.sleepInterval, (Clock)this.clock);
        while (!this.threadMap.isEmpty() && !this.threadMap.values().stream().allMatch(thread -> thread.getState().equals((Object)Thread.State.TERMINATED))) {
            try {
                metronome.pause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOGGER.info("Beginning to terminate threads, task {}", (Object)taskUid);
            Map<String, Thread> unterminatedThreads = this.threadMap.entrySet().stream().filter(entry -> !((Thread)entry.getValue()).getState().equals((Object)Thread.State.TERMINATED)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            LOGGER.info("Task {}, Found {} unterminated threads {}, task {}", new Object[]{taskUid, unterminatedThreads.size(), unterminatedThreads});
            for (Map.Entry<String, Thread> unterminatedThread : unterminatedThreads.entrySet()) {
                LOGGER.info("Task {}, trying to terminate the token {} with state {}", new Object[]{taskUid, unterminatedThread.getKey(), unterminatedThread.getValue().getState()});
                unterminatedThread.getValue().interrupt();
            }
            LOGGER.info("Finished trying to interrupt threads, cleaning {}", (Object)taskUid);
            this.clean();
        }
        LOGGER.info("Successfully shut down partition thread poll for task {}", (Object)taskUid);
    }

    private synchronized void clean() {
        Set<String> tokens = this.threadMap.entrySet().stream().filter(entry -> ((Thread)entry.getValue()).getState().equals((Object)Thread.State.TERMINATED)).map(Map.Entry::getKey).collect(Collectors.toSet());
        tokens.forEach(this.threadMap::remove);
    }

    public synchronized Set<String> getActiveThreads() {
        this.clean();
        return Set.copyOf(this.threadMap.keySet());
    }
}

