/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.stream;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.common.annotations.VisibleForTesting;
import io.debezium.connector.spanner.db.DatabaseClientFactory;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.db.model.event.ChangeStreamEvent;
import io.debezium.connector.spanner.db.stream.ChangeStream;
import io.debezium.connector.spanner.db.stream.ChangeStreamEventConsumer;
import io.debezium.connector.spanner.db.stream.PartitionEventListener;
import io.debezium.connector.spanner.db.stream.PartitionQueryingMonitor;
import io.debezium.connector.spanner.db.stream.PartitionThreadPool;
import io.debezium.connector.spanner.db.stream.SpannerChangeStreamService;
import io.debezium.connector.spanner.db.stream.exception.ChangeStreamException;
import io.debezium.connector.spanner.db.stream.exception.FailureChangeStreamException;
import io.debezium.connector.spanner.db.stream.exception.OutOfRangeChangeStreamException;
import io.debezium.connector.spanner.db.stream.exception.StuckPartitionException;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.ActiveQueriesUpdateMetricEvent;
import io.debezium.connector.spanner.metrics.event.NewQueueMetricEvent;
import io.debezium.connector.spanner.metrics.event.RuntimeErrorMetricEvent;
import io.debezium.function.BlockingConsumer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerChangeStream
implements ChangeStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpannerChangeStream.class);
    public static final Duration WAIT_TIMEOUT = Duration.ofMillis(200L);
    private final SpannerChangeStreamService streamService;
    private final AtomicReference<ChangeStreamException> exception = new AtomicReference();
    private final PartitionThreadPool partitionThreadPool;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition signal = this.lock.newCondition();
    private final MetricsEventPublisher metricsEventPublisher;
    private volatile PartitionEventListener partitionEventListener;
    private volatile ChangeStreamEventConsumer changeStreamEventConsumer;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final PartitionQueryingMonitor partitionQueryingMonitor;
    private final String taskUid;
    private final DatabaseClientFactory databaseClientFactory;

    public SpannerChangeStream(SpannerChangeStreamService streamService, MetricsEventPublisher metricsEventPublisher, Duration heartBeatInterval, int maxMissedHeartbeats, String taskUid, DatabaseClientFactory databaseClientFactory) {
        this.streamService = streamService;
        this.partitionThreadPool = new PartitionThreadPool();
        this.metricsEventPublisher = metricsEventPublisher;
        this.partitionQueryingMonitor = new PartitionQueryingMonitor(this.partitionThreadPool, heartBeatInterval, (BlockingConsumer<String>)((BlockingConsumer)this::onStuckPartition), this::onError, metricsEventPublisher, maxMissedHeartbeats);
        this.taskUid = taskUid;
        this.databaseClientFactory = databaseClientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(BooleanSupplier runningFlagSupplier, ChangeStreamEventConsumer changeStreamEventConsumer, PartitionEventListener partitionEventListener) throws ChangeStreamException, InterruptedException {
        this.changeStreamEventConsumer = changeStreamEventConsumer;
        this.partitionEventListener = partitionEventListener;
        this.isRunning.set(true);
        this.partitionQueryingMonitor.start();
        this.lock.lock();
        try {
            while (runningFlagSupplier.getAsBoolean()) {
                if (this.signal.await(WAIT_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS) && this.exception.get() != null) {
                    LOGGER.warn("Task {}, is throwing exception during streaming {}", (Object)this.taskUid, (Object)this.exception.get());
                    throw this.exception.get();
                }
                this.metricsEventPublisher.publishMetricEvent(new ActiveQueriesUpdateMetricEvent(this.partitionThreadPool.getActiveThreads().size()));
            }
        }
        finally {
            this.partitionQueryingMonitor.stop();
            this.lock.unlock();
            LOGGER.info("Task {}, closing Spanner", (Object)this.taskUid);
            this.databaseClientFactory.closeSpanner();
            LOGGER.info("Task {}, Shutting down all partition streaming...", (Object)this.taskUid);
            this.partitionThreadPool.shutdown(this.taskUid);
            LOGGER.info("Task {}, Shutdown all partition streaming...", (Object)this.taskUid);
            this.isRunning.set(false);
        }
    }

    @Override
    public boolean submitPartition(Partition partition) {
        if (!this.isRunning.get()) {
            LOGGER.info("Task {}, Failed to submit partition: {}", (Object)this.taskUid, (Object)partition.getToken());
            return false;
        }
        boolean submitted = this.partitionThreadPool.submit(partition.getToken(), () -> {
            LOGGER.info("task {}, Started streaming from partition with token {}", (Object)this.taskUid, (Object)partition.getToken());
            try {
                this.streamService.getEvents(partition, this::onStreamEvent, this.partitionEventListener);
            }
            catch (InterruptedException ex) {
                LOGGER.info("task {}, Interrupting streaming partition task with token {}", (Object)this.taskUid, (Object)partition.getToken());
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                LOGGER.info("Exception during streaming {} from partition with token {}", (Object)ex.getMessage(), (Object)partition.getToken());
                if (this.onError(partition, ex)) {
                    LOGGER.info("Unretriable exception during streaming {} from partition with token {}", (Object)ex.getMessage(), (Object)partition.getToken());
                    return;
                }
                try {
                    this.partitionEventListener.onException(partition, ex);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.info("Interrupting streaming partition task with token {} and exception {}, SHOULD NEVER REACH THIS POINT, CHECK IF TASK FAILED", (Object)partition.getToken(), (Object)e);
                }
            }
            finally {
                LOGGER.info("Stopped streaming from partition with token {}", (Object)partition.getToken());
            }
        });
        if (submitted) {
            this.metricsEventPublisher.publishMetricEvent(new NewQueueMetricEvent());
            this.metricsEventPublisher.publishMetricEvent(new ActiveQueriesUpdateMetricEvent(this.partitionThreadPool.getActiveThreads().size()));
        }
        return submitted;
    }

    @VisibleForTesting
    void onStreamEvent(ChangeStreamEvent changeStreamEvent) throws InterruptedException {
        this.partitionQueryingMonitor.acceptStreamEvent(changeStreamEvent);
        this.changeStreamEventConsumer.acceptChangeStreamEvent(changeStreamEvent);
    }

    @VisibleForTesting
    void onStuckPartition(String token) throws InterruptedException {
        LOGGER.warn("Partition {} is stuck", (Object)token);
        this.partitionThreadPool.stop(token);
        if (this.partitionEventListener.onStuckPartition(token)) {
            this.onError(new StuckPartitionException(token));
        }
    }

    @Override
    public void stop(String token) {
        this.partitionThreadPool.stop(token);
        this.metricsEventPublisher.publishMetricEvent(new ActiveQueriesUpdateMetricEvent(this.partitionThreadPool.getActiveThreads().size()));
        LOGGER.info("Stopped streaming from partition with token {}", (Object)token);
    }

    @Override
    public void stop() {
        LOGGER.info("Task {}, closing Spanner", (Object)this.taskUid);
        this.databaseClientFactory.closeSpanner();
        LOGGER.info("Task {}, Shutting down partition thread pool {}", (Object)this.taskUid, this.partitionThreadPool.getActiveThreads());
        this.partitionThreadPool.shutdown(this.taskUid);
        LOGGER.info("Task {}, Shutdown partition thread pool", (Object)this.taskUid);
    }

    @VisibleForTesting
    boolean onError(Partition partition, Exception ex) {
        ChangeStreamException changeStreamException = this.getStreamException(partition, ex);
        return this.onError(changeStreamException);
    }

    @VisibleForTesting
    boolean onError(ChangeStreamException ex) {
        if (ex instanceof FailureChangeStreamException) {
            this.exception.compareAndSet(null, ex);
            this.signal();
            return true;
        }
        this.metricsEventPublisher.publishMetricEvent(new RuntimeErrorMetricEvent());
        return false;
    }

    @VisibleForTesting
    boolean isCanceled(Exception ex) {
        SpannerException spannerException;
        return ex instanceof SpannerException && (spannerException = (SpannerException)ex).getErrorCode().equals((Object)ErrorCode.CANCELLED);
    }

    @VisibleForTesting
    ChangeStreamException getStreamException(Partition partition, Exception ex) {
        if (ex instanceof SpannerException) {
            SpannerException spannerException = (SpannerException)ex;
            switch (spannerException.getErrorCode()) {
                case OUT_OF_RANGE: {
                    return new OutOfRangeChangeStreamException(partition, spannerException);
                }
            }
            return new ChangeStreamException((Exception)spannerException);
        }
        return new FailureChangeStreamException(ex);
    }

    private void signal() {
        this.lock.lock();
        try {
            this.signal.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

