/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.encoding;

import com.datadoghq.sketch.ddsketch.encoding.Output;
import java.util.Arrays;

public final class GrowingByteArrayOutput
implements Output {
    private static final int INITIAL_CAPACITY = 8;
    private byte[] array;
    private int pos = 0;

    private GrowingByteArrayOutput(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be negative");
        }
        this.array = new byte[initialCapacity];
    }

    public static GrowingByteArrayOutput withInitialCapacity(int initialCapacity) {
        return new GrowingByteArrayOutput(initialCapacity);
    }

    public static GrowingByteArrayOutput withDefaultInitialCapacity() {
        return GrowingByteArrayOutput.withInitialCapacity(8);
    }

    private void grow(int requiredCapacity) {
        int newCapacity = Math.max(requiredCapacity, this.array.length << 1);
        byte[] newArray = new byte[newCapacity];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = newArray;
    }

    @Override
    public final void writeByte(byte value) {
        if (this.pos == this.array.length) {
            this.grow(this.pos + 1);
        }
        this.array[this.pos++] = value;
    }

    @Override
    public final void writeLongLE(long value) {
        if (this.pos > this.array.length - 8) {
            this.grow(this.pos + 8);
        }
        this.array[this.pos] = (byte)value;
        this.array[this.pos + 1] = (byte)(value >> 8);
        this.array[this.pos + 2] = (byte)(value >> 16);
        this.array[this.pos + 3] = (byte)(value >> 24);
        this.array[this.pos + 4] = (byte)(value >> 32);
        this.array[this.pos + 5] = (byte)(value >> 40);
        this.array[this.pos + 6] = (byte)(value >> 48);
        this.array[this.pos + 7] = (byte)(value >> 56);
        this.pos += 8;
    }

    public final void clear() {
        this.pos = 0;
    }

    public final byte[] backingArray() {
        return this.array;
    }

    public final int numWrittenBytes() {
        return this.pos;
    }

    public final byte[] trimmedCopy() {
        return Arrays.copyOf(this.array, this.pos);
    }
}

