/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor.metadata;

import io.debezium.connector.spanner.context.offset.SpannerOffsetContext;
import io.debezium.connector.spanner.processor.metadata.SpannerEventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Struct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SpannerEventMetadataProviderTest {
    SpannerEventMetadataProviderTest() {
    }

    @Test
    void testGetEventTimestampNull() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        Assertions.assertNull((Object)spannerEventMetadataProvider.getEventTimestamp((DataCollectionId)new TableId("Catalog Name", "Schema Name", "Table Name"), (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", null));
    }

    @Test
    void testGetEventTimestampNullValue() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        TableId tableId = new TableId("Catalog Name", "Schema Name", "Table Name");
        Assertions.assertNull((Object)spannerEventMetadataProvider.getEventTimestamp((DataCollectionId)tableId, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", null));
    }

    @Test
    void testGetEventTimestampTableIdNull() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Assertions.assertNull((Object)spannerEventMetadataProvider.getEventTimestamp(null, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", struct));
    }

    @Test
    void testGetEventTimestamp() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        TableId tableId = new TableId("Catalog Name", "Schema Name", "Table Name");
        Mockito.when((Object)struct.getStruct(ArgumentMatchers.anyString())).thenReturn((Object)struct);
        Mockito.when((Object)struct.getInt64(ArgumentMatchers.anyString())).thenReturn((Object)1L);
        Assertions.assertNotNull((Object)spannerEventMetadataProvider.getEventTimestamp((DataCollectionId)tableId, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", struct));
        Mockito.when((Object)struct.getInt64(ArgumentMatchers.anyString())).thenReturn(null);
        Assertions.assertNull((Object)spannerEventMetadataProvider.getEventTimestamp((DataCollectionId)tableId, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", struct));
    }

    @Test
    void testGetEventSourcePositionNullValue() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        TableId tableId = new TableId("Catalog Name", "Schema Name", "Table Name");
        Assertions.assertNull((Object)spannerEventMetadataProvider.getEventSourcePosition((DataCollectionId)tableId, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", null));
    }

    @Test
    void testGetEventSourcePositionTableIdNull() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Assertions.assertNull((Object)spannerEventMetadataProvider.getEventSourcePosition(null, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", struct));
    }

    @Test
    void testGetEventSourcePositionTable() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        TableId tableId = new TableId("Catalog Name", "Schema Name", "Table Name");
        Mockito.when((Object)struct.getStruct(ArgumentMatchers.anyString())).thenReturn((Object)struct);
        Assertions.assertNotNull((Object)spannerEventMetadataProvider.getEventSourcePosition((DataCollectionId)tableId, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", struct));
    }

    @Test
    void testGetTransactionIdNullValue() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        TableId tableId = new TableId("Catalog Name", "Schema Name", "Table Name");
        Assertions.assertNull((Object)spannerEventMetadataProvider.getTransactionId((DataCollectionId)tableId, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", null));
    }

    @Test
    void testGetTransactionIdTableIdNull() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        Assertions.assertNull((Object)spannerEventMetadataProvider.getTransactionId(null, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", struct));
    }

    @Test
    void testGetTransactionIdTable() {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        Struct struct = (Struct)Mockito.mock(Struct.class);
        TableId tableId = new TableId("Catalog Name", "Schema Name", "Table Name");
        Mockito.when((Object)struct.getStruct(ArgumentMatchers.anyString())).thenReturn((Object)struct);
        Mockito.when((Object)struct.getString(ArgumentMatchers.anyString())).thenReturn((Object)"struct");
        Assertions.assertNotNull((Object)spannerEventMetadataProvider.getTransactionId((DataCollectionId)tableId, (OffsetContext)Mockito.mock(SpannerOffsetContext.class), (Object)"Key", struct));
    }

    private static Stream<Arguments> summaryStringProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, null, "42", null, "key: 42"}), Arguments.of((Object[])new Object[]{null, null, null, null, ""}), Arguments.of((Object[])new Object[]{new TableId("Catalog Name", "Schema Name", "Table Name"), Mockito.mock(SpannerOffsetContext.class), "Key", null, "key: Key"}));
    }

    @ParameterizedTest
    @MethodSource(value={"summaryStringProvider"})
    void testToSummaryString(DataCollectionId source, OffsetContext offset, Object key, Struct value, String expected) {
        SpannerEventMetadataProvider spannerEventMetadataProvider = new SpannerEventMetadataProvider();
        Assertions.assertEquals((Object)expected, (Object)spannerEventMetadataProvider.toSummaryString(source, offset, key, value));
    }
}

