/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import com.datadoghq.sketch.ddsketch.store.CollapsingDenseStore;
import com.datadoghq.sketch.ddsketch.store.Store;

public class CollapsingLowestDenseStore
extends CollapsingDenseStore {
    public CollapsingLowestDenseStore(int maxNumBins) {
        super(maxNumBins);
    }

    private CollapsingLowestDenseStore(CollapsingLowestDenseStore store) {
        super(store);
    }

    @Override
    int normalize(int index) {
        if (index < this.minIndex) {
            if (this.isCollapsed) {
                return 0;
            }
            this.extendRange(index);
            if (this.isCollapsed) {
                return 0;
            }
        } else if (index > this.maxIndex) {
            this.extendRange(index);
        }
        return index - this.offset;
    }

    @Override
    void adjust(int newMinIndex, int newMaxIndex) {
        if ((long)newMaxIndex - (long)newMinIndex + 1L > (long)this.counts.length) {
            newMinIndex = newMaxIndex - this.counts.length + 1;
            if (newMinIndex >= this.maxIndex) {
                double totalCount = this.getTotalCount();
                this.resetCounts();
                this.offset = newMinIndex;
                this.minIndex = newMinIndex;
                this.counts[0] = totalCount;
            } else {
                int shift = this.offset - newMinIndex;
                if (shift < 0) {
                    double collapsedCount = this.getTotalCount(this.minIndex, newMinIndex - 1);
                    this.resetCounts(this.minIndex, newMinIndex - 1);
                    int n = newMinIndex - this.offset;
                    this.counts[n] = this.counts[n] + collapsedCount;
                    this.minIndex = newMinIndex;
                    this.shiftCounts(shift);
                } else {
                    this.shiftCounts(shift);
                    this.minIndex = newMinIndex;
                }
            }
            this.maxIndex = newMaxIndex;
            this.isCollapsed = true;
        } else {
            this.centerCounts(newMinIndex, newMaxIndex);
        }
    }

    @Override
    public Store copy() {
        return new CollapsingLowestDenseStore(this);
    }

    @Override
    public void mergeWith(Store store) {
        if (store instanceof CollapsingLowestDenseStore) {
            this.mergeWith((CollapsingLowestDenseStore)store);
        } else {
            this.getDescendingStream().forEachOrdered(this::add);
        }
    }

    private void mergeWith(CollapsingLowestDenseStore store) {
        int index;
        if (store.isEmpty()) {
            return;
        }
        if (store.minIndex < this.minIndex || store.maxIndex > this.maxIndex) {
            this.extendRange(store.minIndex, store.maxIndex);
        }
        for (index = store.minIndex; index < this.minIndex && index <= store.maxIndex; ++index) {
            this.counts[0] = this.counts[0] + store.counts[index - store.offset];
        }
        while (index < store.maxIndex) {
            int n = index - this.offset;
            this.counts[n] = this.counts[n] + store.counts[index - store.offset];
            ++index;
        }
        if (index == store.maxIndex) {
            int n = index - this.offset;
            this.counts[n] = this.counts[n] + store.counts[index - store.offset];
        }
    }
}

