/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.TaskSyncPublisher;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceState;
import io.debezium.connector.spanner.kafka.internal.model.SyncEventMetadata;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.SyncEventMerger;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import io.debezium.connector.spanner.task.state.SyncEvent;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import io.debezium.function.BlockingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncEventHandler.class);
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final TaskSyncPublisher taskSyncPublisher;
    private final BlockingConsumer<TaskStateChangeEvent> eventConsumer;

    public SyncEventHandler(TaskSyncContextHolder taskSyncContextHolder, TaskSyncPublisher taskSyncPublisher, BlockingConsumer<TaskStateChangeEvent> eventConsumer) {
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.taskSyncPublisher = taskSyncPublisher;
        this.eventConsumer = eventConsumer;
    }

    public void updateCurrentOffset(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        if (inSync == null) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.update(oldContext -> oldContext.toBuilder().currentKafkaRecordOffset(metadata.getOffset()).build());
        LOGGER.debug("Task {} - update task sync topic offset with {}", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)metadata.getOffset());
    }

    public void processPreviousStates(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        if (!RebalanceState.START_INITIAL_SYNC.equals((Object)this.taskSyncContextHolder.get().getRebalanceState())) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            if (metadata.isCanInitiateRebalancing()) {
                LOGGER.info("task {}, skipping stale message, finished processing all previous sync event messages with end offset {}, can initiate rebalancing", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)metadata.getOffset());
                this.taskSyncContextHolder.update(context -> context.toBuilder().rebalanceState(RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED).epochOffsetHolder(context.getEpochOffsetHolder().nextOffset(context.getCurrentKafkaRecordOffset())).build());
            }
            return;
        }
        this.taskSyncContextHolder.lock();
        try {
            if (inSync != null) {
                if (inSync.getMessageType() == MessageTypeEnum.NEW_EPOCH) {
                    LOGGER.info("Task {} - processPreviousStates - merge new epoch with rebalance generation ID {}", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)inSync.getRebalanceGenerationId());
                    this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeNewEpoch(context, inSync));
                } else {
                    this.taskSyncContextHolder.update(context -> SyncEventMerger.merge(context, inSync));
                }
            }
            if (metadata.isCanInitiateRebalancing()) {
                LOGGER.info("task {}, finished processing all previous sync event messages with end offset {}, can initiate rebalancing", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)metadata.getOffset());
                this.taskSyncContextHolder.update(context -> context.toBuilder().rebalanceState(RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED).epochOffsetHolder(context.getEpochOffsetHolder().nextOffset(context.getCurrentKafkaRecordOffset())).build());
                LOGGER.info("Task {} - now initialized with epoch offset {} and context {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), this.taskSyncContextHolder.get().getEpochOffsetHolder().getEpochOffset(), this.taskSyncContextHolder.get()});
                this.taskSyncContextHolder.get().checkDuplication(true, "Finished Initializing Task State");
            }
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNewEpoch(TaskSyncEvent inSync, SyncEventMetadata metadata) throws InterruptedException {
        if (inSync == null) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.lock();
        try {
            long currentGeneration = this.taskSyncContextHolder.get().getRebalanceGenerationId();
            long inGeneration = inSync.getRebalanceGenerationId();
            if (this.taskSyncContextHolder.get().getRebalanceState() == RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED && inSync.getMessageType() == MessageTypeEnum.NEW_EPOCH && inGeneration >= currentGeneration) {
                LOGGER.debug("Task {} - processNewEpoch {}", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)inSync);
                LOGGER.info("Task {} - processNewEpoch : metadata {}, rebalanceId: {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), metadata, inSync.getRebalanceGenerationId()});
                this.taskSyncContextHolder.update(context -> SyncEventMerger.mergeNewEpoch(context, inSync));
                LOGGER.info("Task {} - SyncEventHandler sent response for new epoch", (Object)this.taskSyncContextHolder.get().getTaskUid());
                this.taskSyncPublisher.send(this.taskSyncContextHolder.get().buildTaskSyncEvent());
            }
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
    }

    public void process(TaskSyncEvent inSync, SyncEventMetadata metadata) throws InterruptedException {
        if (inSync == null) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.lock();
        try {
            if (!this.taskSyncContextHolder.get().getRebalanceState().equals((Object)RebalanceState.NEW_EPOCH_STARTED)) {
                return;
            }
            if (inSync.getMessageType() == MessageTypeEnum.NEW_EPOCH || inSync.getMessageType() == MessageTypeEnum.REBALANCE_ANSWER) {
                LOGGER.warn("Task {} - should have already processed sync message from task {} with message type {}", new Object[]{this.taskSyncContextHolder.get().getTaskUid(), inSync.getTaskUid(), inSync.getMessageType()});
            }
            LOGGER.debug("Task {} - process sync event", (Object)this.taskSyncContextHolder.get().getTaskUid());
            this.taskSyncContextHolder.update(context -> SyncEventMerger.merge(context, inSync));
            this.eventConsumer.accept((Object)new SyncEvent());
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
    }

    public void processRebalanceAnswer(TaskSyncEvent inSync, SyncEventMetadata metadata) {
        if (inSync == null) {
            return;
        }
        if (this.skipFromPreviousGeneration(inSync)) {
            return;
        }
        this.taskSyncContextHolder.lock();
        try {
            if (!this.taskSyncContextHolder.get().isLeader() || !this.taskSyncContextHolder.get().getRebalanceState().equals((Object)RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED)) {
                return;
            }
            LOGGER.info("Task {} - process sync event - rebalance answer", (Object)this.taskSyncContextHolder.get().getTaskUid());
            this.taskSyncContextHolder.update(context -> SyncEventMerger.merge(context, inSync));
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
    }

    private boolean skipFromPreviousGeneration(TaskSyncEvent inSync) {
        long currentGeneration;
        long inGeneration;
        if (inSync != null && (inGeneration = inSync.getRebalanceGenerationId()) < (currentGeneration = this.taskSyncContextHolder.get().getRebalanceGenerationId())) {
            LOGGER.debug("skipFromPreviousGeneration: currentGen: {}, inGen: {}, inTaskUid: {}", new Object[]{currentGeneration, inGeneration, inSync.getTaskUid()});
            return true;
        }
        return false;
    }
}

