/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.task.LowWatermarkCalculator;
import io.debezium.connector.spanner.task.LowWatermarkHolder;
import io.debezium.util.Stopwatch;
import java.time.Duration;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowWatermarkCalculationJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowWatermarkCalculationJob.class);
    private volatile Thread mainThread;
    private volatile Thread calculationThread;
    private final Duration pollInterval = Duration.ofMillis(600000L);
    private final Consumer<Throwable> errorHandler;
    private final boolean enabled;
    private final long period;
    private final LowWatermarkCalculator lowWatermarkCalculator;
    private final LowWatermarkHolder lowWatermarkHolder;
    private final Lock lock = new ReentrantLock();
    private final Condition signal = this.lock.newCondition();

    public LowWatermarkCalculationJob(SpannerConnectorConfig connectorConfig, Consumer<Throwable> errorHandler, LowWatermarkCalculator lowWatermarkCalculator, LowWatermarkHolder lowWatermarkHolder) {
        this.errorHandler = errorHandler;
        this.lowWatermarkCalculator = lowWatermarkCalculator;
        this.lowWatermarkHolder = lowWatermarkHolder;
        this.enabled = connectorConfig.isLowWatermarkEnabled();
        this.period = connectorConfig.getLowWatermarkUpdatePeriodMs();
    }

    private Thread createMainThread() {
        Thread thread = new Thread(this::lambda$createMainThread$0, "SpannerConnector-WatermarkCalculationJob");
        thread.setUncaughtExceptionHandler((t, e) -> this.errorHandler.accept(e));
        return thread;
    }

    private Thread createCalculationThread() {
        Thread thread = new Thread(this::lambda$createCalculationThread$2, "SpannerConnector-WatermarkCalculationJob-Calculation");
        thread.setUncaughtExceptionHandler((t, e) -> this.errorHandler.accept(e));
        return thread;
    }

    private void getLowWatermark(boolean printOffsets) throws InterruptedException {
        Timestamp timestamp;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        while ((timestamp = this.lowWatermarkCalculator.calculateLowWatermark(printOffsets)) == null) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Thread.sleep(1L);
        }
        this.lowWatermarkHolder.setLowWatermark(timestamp);
    }

    public void start() {
        if (!this.enabled) {
            return;
        }
        this.calculationThread = this.createCalculationThread();
        this.calculationThread.start();
        this.mainThread = this.createMainThread();
        this.mainThread.start();
    }

    public void stop() {
        if (this.mainThread != null) {
            this.mainThread.interrupt();
            this.mainThread = null;
        }
        if (this.calculationThread != null) {
            this.calculationThread.interrupt();
            this.calculationThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$createCalculationThread$2() {
        sw = Stopwatch.accumulating().start();
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                this.lock.lock();
                try {
                    this.signal.await();
                    totalDuration = sw.stop().durations().statistics().getTotal();
                    printOffsets = false;
                    if (totalDuration.toMillis() >= this.pollInterval.toMillis()) {
                        printOffsets = true;
                        sw = Stopwatch.accumulating().start();
                    } else {
                        sw.start();
                    }
                    this.getLowWatermark(printOffsets);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        ** GOTO lbl-1000
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$createMainThread$0() {
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                Thread.sleep(this.period);
                if (!this.lock.tryLock()) continue;
                try {
                    this.signal.signal();
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        ** GOTO lbl-1000
    }
}

