/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.schema.mapper;

import io.debezium.connector.spanner.db.mapper.parser.ColumnTypeParser;
import io.debezium.connector.spanner.db.model.schema.ColumnType;
import io.debezium.connector.spanner.schema.mapper.ColumnTypeSchemaMapper;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ColumnTypeSchemaMapperTest {
    ColumnTypeSchemaMapperTest() {
    }

    private static Stream<Arguments> schemaProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"array_element_type\":{\"code\":\"BOOL\"},\"code\":\"ARRAY\"}"), (boolean)true), SchemaBuilder.array((Schema)Schema.BOOLEAN_SCHEMA).optional()}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"STRING\"}"), (boolean)true), Schema.OPTIONAL_STRING_SCHEMA}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"NUMERIC\"}"), (boolean)true), Schema.OPTIONAL_STRING_SCHEMA}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"DATE\"}"), (boolean)true), Schema.OPTIONAL_STRING_SCHEMA}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"JSON\"}"), (boolean)true), Schema.OPTIONAL_STRING_SCHEMA}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"TIMESTAMP\"}"), (boolean)true), Schema.OPTIONAL_STRING_SCHEMA}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"INT64\"}"), (boolean)true), Schema.OPTIONAL_INT64_SCHEMA}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"BOOL\"}"), (boolean)true), Schema.OPTIONAL_BOOLEAN_SCHEMA}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"FLOAT64\"}"), (boolean)true), Schema.OPTIONAL_FLOAT64_SCHEMA}), Arguments.of((Object[])new Object[]{ColumnTypeSchemaMapper.getSchema((ColumnType)ColumnTypeParser.parse((String)"{\"code\":\"BYTES\"}"), (boolean)true), SchemaBuilder.bytes().optional()}));
    }

    @ParameterizedTest
    @MethodSource(value={"schemaProvider"})
    void parse(Schema schema, Schema expected) {
        Assertions.assertEquals((Object)expected.type(), (Object)schema.type());
        Assertions.assertEquals((Object)expected.isOptional(), (Object)schema.isOptional());
        Assertions.assertEquals((Object)expected.defaultValue(), (Object)schema.defaultValue());
        Assertions.assertEquals((Object)expected.name(), (Object)schema.name());
        Assertions.assertEquals((Integer)expected.version(), (Integer)schema.version());
        Assertions.assertEquals((Object)expected.doc(), (Object)schema.doc());
        Assertions.assertEquals((Object)expected.parameters(), (Object)schema.parameters());
        Assertions.assertEquals((Object)expected.schema().type(), (Object)schema.schema().type());
    }
}

