/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal.proto;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.kafka.event.proto.SyncEventProtos;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.kafka.internal.proto.SyncEventFromProtoMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SyncEventFromProtoMapperTest {
    SyncEventFromProtoMapperTest() {
    }

    @Test
    void testMapFromProto() {
        SyncEventProtos.PartitionState protoPartition1 = SyncEventProtos.PartitionState.newBuilder().setToken("aqaqa098----08989").addAllParents(List.of("p1", "p2")).setStartTimestamp("1970-01-01T00:00:00.000002000Z").setState(SyncEventProtos.State.CREATED).setAssigneeTaskUid("2llll").setEndTimestamp("1970-01-01T00:00:00.000001000Z").build();
        SyncEventProtos.PartitionState protoPartition2 = SyncEventProtos.PartitionState.newBuilder().setToken("eeeea098----08989").addAllParents(List.of("p4", "p7")).setStartTimestamp("1970-01-01T00:00:00.000007000Z").setState(SyncEventProtos.State.READY_FOR_STREAMING).setAssigneeTaskUid("2llll").setEndTimestamp("1970-01-01T00:00:00.000008000Z").build();
        SyncEventProtos.TaskState protoState1 = SyncEventProtos.TaskState.newBuilder().setTaskUid("uienjnjaaaa").setConsumerId("ppp323323").setRebalanceGenerationId(7878L).setStateTimestamp(11111L).addAllPartitions(List.of(protoPartition1, protoPartition2)).addAllSharedPartitions(List.of(protoPartition2)).build();
        SyncEventProtos.TaskState protoState2 = SyncEventProtos.TaskState.newBuilder().setTaskUid("ttytgtg").setConsumerId("hhhj3344").setRebalanceGenerationId(45444L).setStateTimestamp(111166661L).addAllPartitions(List.of(protoPartition2)).addAllSharedPartitions(List.of()).build();
        SyncEventProtos.SyncEvent protoEvent = SyncEventProtos.SyncEvent.newBuilder().setTaskUid("t2283238").setConsumerId("c2323399800").setMessageTimestamp(123989L).setMessageType(SyncEventProtos.MessageType.REBALANCE_ANSWER).setRebalanceGenerationId(90L).setEpochOffset(123L).addAllTaskStates(List.of(protoState1, protoState2)).build();
        TaskSyncEvent taskSyncEvent = SyncEventFromProtoMapper.mapFromProto((SyncEventProtos.SyncEvent)protoEvent);
        Assertions.assertThat((String)taskSyncEvent.getTaskUid()).isEqualTo(protoEvent.getTaskUid());
        Assertions.assertThat((String)taskSyncEvent.getConsumerId()).isEqualTo(protoEvent.getConsumerId());
        Assertions.assertThat((long)taskSyncEvent.getMessageTimestamp()).isEqualTo(protoEvent.getMessageTimestamp());
        Assertions.assertThat((Comparable)taskSyncEvent.getMessageType()).isEqualTo((Object)MessageTypeEnum.REBALANCE_ANSWER);
        Assertions.assertThat((long)taskSyncEvent.getRebalanceGenerationId()).isEqualTo(protoEvent.getRebalanceGenerationId());
        Assertions.assertThat((long)taskSyncEvent.getEpochOffset()).isEqualTo(protoEvent.getEpochOffset());
        Assertions.assertThat((Map)taskSyncEvent.getTaskStates()).hasSize(2);
        TaskState taskState1 = (TaskState)taskSyncEvent.getTaskStates().get(protoState1.getTaskUid());
        Assertions.assertThat((String)taskState1.getTaskUid()).isEqualTo(protoState1.getTaskUid());
        Assertions.assertThat((String)taskState1.getConsumerId()).isEqualTo(protoState1.getConsumerId());
        Assertions.assertThat((long)taskState1.getRebalanceGenerationId()).isEqualTo(protoState1.getRebalanceGenerationId());
        Assertions.assertThat((long)taskState1.getStateTimestamp()).isEqualTo(protoState1.getStateTimestamp());
        Assertions.assertThat((Map)taskState1.getPartitionsMap()).hasSize(2);
        PartitionState partition1 = (PartitionState)taskState1.getPartitionsMap().get(protoPartition1.getToken());
        this.assertPartition(partition1, protoPartition1, PartitionStateEnum.CREATED);
        PartitionState partition2 = (PartitionState)taskState1.getPartitionsMap().get(protoPartition2.getToken());
        this.assertPartition(partition2, protoPartition2, PartitionStateEnum.READY_FOR_STREAMING);
        Assertions.assertThat((Collection)taskState1.getSharedPartitions()).hasSize(1);
        PartitionState shared2 = (PartitionState)taskState1.getPartitionsMap().get(protoPartition2.getToken());
        this.assertPartition(shared2, protoPartition2, PartitionStateEnum.READY_FOR_STREAMING);
        TaskState taskState2 = (TaskState)taskSyncEvent.getTaskStates().get(protoState2.getTaskUid());
        Assertions.assertThat((String)taskState2.getTaskUid()).isEqualTo(protoState2.getTaskUid());
        Assertions.assertThat((String)taskState2.getConsumerId()).isEqualTo(protoState2.getConsumerId());
        Assertions.assertThat((long)taskState2.getRebalanceGenerationId()).isEqualTo(protoState2.getRebalanceGenerationId());
        Assertions.assertThat((long)taskState2.getStateTimestamp()).isEqualTo(protoState2.getStateTimestamp());
        Assertions.assertThat((Map)taskState2.getPartitionsMap()).hasSize(1);
        PartitionState partition22 = (PartitionState)taskState2.getPartitionsMap().get(protoPartition2.getToken());
        this.assertPartition(partition22, protoPartition2, PartitionStateEnum.READY_FOR_STREAMING);
        Assertions.assertThat((Map)taskState2.getSharedPartitionsMap()).isEmpty();
    }

    private void assertPartition(PartitionState actual, SyncEventProtos.PartitionState expected, PartitionStateEnum partitionState) {
        Assertions.assertThat((String)actual.getToken()).isEqualTo(expected.getToken());
        Assertions.assertThat((Collection)actual.getParents()).containsExactlyInAnyOrderElementsOf((Iterable)expected.getParentsList());
        Assertions.assertThat((Comparable)actual.getStartTimestamp()).isEqualTo((Object)Timestamp.parseTimestamp((String)expected.getStartTimestamp()));
        Assertions.assertThat((Comparable)actual.getState()).isEqualTo((Object)partitionState);
        Assertions.assertThat((String)actual.getAssigneeTaskUid()).isEqualTo(expected.getAssigneeTaskUid());
        Assertions.assertThat((Comparable)actual.getEndTimestamp()).isEqualTo((Object)Timestamp.parseTimestamp((String)expected.getEndTimestamp()));
    }
}

