/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigurationDefaults;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotChangeEventSource<P extends Partition, O extends OffsetContext>
implements SnapshotChangeEventSource<P, O>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSnapshotChangeEventSource.class);
    public static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
    private final CommonConnectorConfig connectorConfig;
    private final SnapshotProgressListener<P> snapshotProgressListener;
    private final NotificationService<P, O> notificationService;

    public AbstractSnapshotChangeEventSource(CommonConnectorConfig connectorConfig, SnapshotProgressListener<P> snapshotProgressListener, NotificationService<P, O> notificationService) {
        this.connectorConfig = connectorConfig;
        this.snapshotProgressListener = snapshotProgressListener;
        this.notificationService = notificationService;
    }

    protected Offsets<P, OffsetContext> getOffsets(SnapshotContext<P, O> ctx, O previousOffset, SnapshottingTask snapshottingTask) {
        return Offsets.of(ctx.partition, previousOffset);
    }

    @Override
    public SnapshotResult<O> execute(ChangeEventSource.ChangeEventSourceContext context, P partition, O previousOffset) throws InterruptedException {
        SnapshotContext<P, O> ctx;
        SnapshottingTask snapshottingTask = this.getSnapshottingTask(partition, previousOffset);
        try {
            ctx = this.prepare(partition);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize snapshot context.", (Throwable)e);
            throw new RuntimeException(e);
        }
        Offsets<P, OffsetContext> offsets = this.getOffsets(ctx, previousOffset, snapshottingTask);
        if (snapshottingTask.shouldSkipSnapshot()) {
            LOGGER.debug("Skipping snapshotting");
            this.notificationService.initialSnapshotNotificationService().notifySkipped(offsets.getTheOnlyPartition(), offsets.getTheOnlyOffset());
            return SnapshotResult.skipped(previousOffset);
        }
        this.delaySnapshotIfNeeded(context);
        boolean completedSuccessfully = true;
        try {
            this.snapshotProgressListener.snapshotStarted(partition);
            this.notificationService.initialSnapshotNotificationService().notifyStarted(offsets.getTheOnlyPartition(), offsets.getTheOnlyOffset());
            SnapshotResult<O> snapshotResult = this.doExecute(context, previousOffset, ctx, snapshottingTask);
            return snapshotResult;
        }
        catch (InterruptedException e) {
            completedSuccessfully = false;
            LOGGER.warn("Snapshot was interrupted before completion");
            throw e;
        }
        catch (Exception t) {
            completedSuccessfully = false;
            throw new DebeziumException((Throwable)t);
        }
        finally {
            LOGGER.info("Snapshot - Final stage");
            this.close();
            if (completedSuccessfully) {
                LOGGER.info("Snapshot completed");
                this.completed(ctx);
                this.snapshotProgressListener.snapshotCompleted(partition);
                this.notificationService.initialSnapshotNotificationService().notifyCompleted(offsets.getTheOnlyPartition(), offsets.getTheOnlyOffset());
            } else {
                LOGGER.warn("Snapshot was not completed successfully, it will be re-executed upon connector restart");
                this.aborted(ctx);
                this.snapshotProgressListener.snapshotAborted(offsets.getTheOnlyPartition());
            }
        }
    }

    protected <T extends DataCollectionId> Stream<T> determineDataCollectionsToBeSnapshotted(Collection<T> allDataCollections) {
        Set<Pattern> snapshotAllowedDataCollections = this.connectorConfig.getDataCollectionsToBeSnapshotted();
        if (snapshotAllowedDataCollections.size() == 0) {
            return allDataCollections.stream();
        }
        return allDataCollections.stream().filter(dataCollectionId -> snapshotAllowedDataCollections.stream().anyMatch(s -> s.matcher(dataCollectionId.identifier()).matches()));
    }

    protected void delaySnapshotIfNeeded(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        Duration snapshotDelay = this.connectorConfig.getSnapshotDelay();
        if (snapshotDelay.isZero() || snapshotDelay.isNegative()) {
            return;
        }
        Threads.Timer timer = Threads.timer(Clock.SYSTEM, snapshotDelay);
        Metronome metronome = Metronome.parker(ConfigurationDefaults.RETURN_CONTROL_INTERVAL, Clock.SYSTEM);
        while (!timer.expired()) {
            if (!context.isRunning()) {
                throw new InterruptedException("Interrupted while awaiting initial snapshot delay");
            }
            LOGGER.info("The connector will wait for {}s before proceeding", (Object)timer.remaining().getSeconds());
            metronome.pause();
        }
    }

    protected abstract SnapshotResult<O> doExecute(ChangeEventSource.ChangeEventSourceContext var1, O var2, SnapshotContext<P, O> var3, SnapshottingTask var4) throws Exception;

    protected abstract SnapshottingTask getSnapshottingTask(P var1, O var2);

    protected abstract SnapshotContext<P, O> prepare(P var1) throws Exception;

    @Override
    public void close() {
    }

    protected void completed(SnapshotContext<P, O> snapshotContext) {
    }

    protected void aborted(SnapshotContext<P, O> snapshotContext) {
    }

    public static class SnapshotContext<P extends Partition, O extends OffsetContext>
    implements AutoCloseable {
        public P partition;
        public O offset;

        public SnapshotContext(P partition) {
            this.partition = partition;
        }

        @Override
        public void close() throws Exception {
        }
    }

    public static class SnapshottingTask {
        private final boolean snapshotSchema;
        private final boolean snapshotData;

        public SnapshottingTask(boolean snapshotSchema, boolean snapshotData) {
            this.snapshotSchema = snapshotSchema;
            this.snapshotData = snapshotData;
        }

        public boolean snapshotData() {
            return this.snapshotData;
        }

        public boolean snapshotSchema() {
            return this.snapshotSchema;
        }

        public boolean shouldSkipSnapshot() {
            return !this.snapshotSchema() && !this.snapshotData();
        }

        public String toString() {
            return "SnapshottingTask [snapshotSchema=" + this.snapshotSchema + ", snapshotData=" + this.snapshotData + "]";
        }
    }
}

