/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaskTestHelper {
    private TaskTestHelper() {
    }

    public static TaskState generateTaskStateWithPartitions(List<PartitionState> partitions) {
        return TaskState.builder().taskUid(UUID.randomUUID().toString()).partitions(partitions).sharedPartitions(List.of()).build();
    }

    public static TaskState generateTaskStateWithRandomPartitions(int partitionsCount, int sharedPartitionsCount) {
        return TaskState.builder().taskUid(UUID.randomUUID().toString()).partitions(TaskTestHelper.generateRandomPartitions(partitionsCount)).sharedPartitions(TaskTestHelper.generateRandomPartitions(sharedPartitionsCount)).build();
    }

    public static TaskSyncEvent createTaskSyncEvent(TaskState ... taskStates) {
        return TaskSyncEvent.builder().taskStates(TaskTestHelper.createTaskStateMap(taskStates)).build();
    }

    public static Map<String, TaskState> createTaskStateMap(TaskState ... taskStates) {
        return Stream.of(taskStates).collect(Collectors.toUnmodifiableMap(TaskState::getTaskUid, Function.identity()));
    }

    public static List<PartitionState> generateRandomPartitions(int count) {
        return Stream.generate(TaskTestHelper::generateRandomPartition).limit(count).collect(Collectors.toUnmodifiableList());
    }

    public static PartitionState generateRandomPartition() {
        return PartitionState.builder().token(UUID.randomUUID().toString()).build();
    }

    public static List<PartitionState> generatePartitions(int count, Supplier<PartitionState> partitionStateSupplier) {
        return Stream.generate(partitionStateSupplier).limit(count).collect(Collectors.toUnmodifiableList());
    }

    public static PartitionState findPartitionStateByToken(Collection<PartitionState> partitions, String token) {
        return partitions.stream().filter(p -> p.getToken().equals(token)).findFirst().orElseThrow();
    }

    public static List<PartitionState> findPartitionStatesByAssignee(List<PartitionState> partitions, String assigneeTaskUid) {
        return partitions.stream().filter(p -> p.getAssigneeTaskUid().equals(assigneeTaskUid)).collect(Collectors.toList());
    }

    public static List<String> extractTokens(List<PartitionState> partitions) {
        return partitions.stream().map(PartitionState::getToken).collect(Collectors.toList());
    }
}

