/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.config.BaseSpannerConnectorConfig;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class BaseSpannerConnectorConfigTest {
    BaseSpannerConnectorConfigTest() {
    }

    @Test
    void testConfigDef() {
        ConfigDef actualConfigDefResult = BaseSpannerConnectorConfig.configDef();
        Map configKeysResult = actualConfigDefResult.configKeys();
        Assertions.assertEquals((int)53, (int)configKeysResult.size());
        List groupsResult = actualConfigDefResult.groups();
        Assertions.assertEquals((int)3, (int)groupsResult.size());
        Assertions.assertEquals((Object)"Spanner", groupsResult.get(0));
        Assertions.assertEquals((Object)"Connector", groupsResult.get(1));
        Assertions.assertEquals((Object)"Events", groupsResult.get(2));
        ConfigDef.ConfigKey getResult = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.change.stream");
        Assertions.assertEquals((Object)ConfigDef.Width.MEDIUM, (Object)getResult.width);
        ConfigDef.ConfigKey getResult1 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.instance.id");
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult1.width);
        Assertions.assertNull((Object)getResult1.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult1.type);
        Assertions.assertNull((Object)getResult1.recommender);
        Assertions.assertEquals((int)1, (int)getResult1.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.instance.id", (Object)getResult1.name);
        Assertions.assertFalse((boolean)getResult1.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResult1.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult1.group);
        Assertions.assertEquals((Object)"Spanner instance id", (Object)getResult1.documentation);
        Assertions.assertEquals((Object)"InstanceId", (Object)getResult1.displayName);
        Assertions.assertTrue((boolean)getResult1.dependents.isEmpty());
        Assertions.assertNull((Object)getResult1.defaultValue);
        Assertions.assertNull((Object)getResult.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult.type);
        Assertions.assertNull((Object)getResult.recommender);
        Assertions.assertEquals((int)4, (int)getResult.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.change.stream", (Object)getResult.name);
        Assertions.assertFalse((boolean)getResult.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResult.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult.group);
        Assertions.assertEquals((Object)"Spanner change stream name", (Object)getResult.documentation);
        Assertions.assertEquals((Object)"Change stream name", (Object)getResult.displayName);
        Assertions.assertNull((Object)getResult.defaultValue);
        ConfigDef.ConfigKey getResult2 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.database.id");
        Assertions.assertNull((Object)getResult2.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult2.type);
        Assertions.assertNull((Object)getResult2.recommender);
        Assertions.assertEquals((int)2, (int)getResult2.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.database.id", (Object)getResult2.name);
        Assertions.assertFalse((boolean)getResult2.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResult2.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult2.group);
        Assertions.assertEquals((Object)"Spanner database id", (Object)getResult2.documentation);
        Assertions.assertEquals((Object)"DatabaseId", (Object)getResult2.displayName);
        Assertions.assertNull((Object)getResult2.defaultValue);
        ConfigDef.ConfigKey getResult3 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.project.id");
        Assertions.assertNull((Object)getResult3.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult3.type);
        Assertions.assertNull((Object)getResult3.recommender);
        Assertions.assertEquals((int)1, (int)getResult3.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.project.id", (Object)getResult3.name);
        Assertions.assertFalse((boolean)getResult3.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.HIGH, (Object)getResult3.importance);
        Assertions.assertEquals((Object)"Spanner", (Object)getResult3.group);
        Assertions.assertEquals((Object)"Spanner project id", (Object)getResult3.documentation);
        Assertions.assertEquals((Object)"ProjectId", (Object)getResult3.displayName);
        Assertions.assertNull((Object)getResult3.defaultValue);
        ConfigDef.ConfigKey getResult4 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.start.time");
        Assertions.assertNull((Object)getResult4.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult4.type);
        Assertions.assertNull((Object)getResult4.recommender);
        Assertions.assertEquals((int)5, (int)getResult4.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.start.time", (Object)getResult4.name);
        Assertions.assertFalse((boolean)getResult4.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.MEDIUM, (Object)getResult4.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult4.group);
        Assertions.assertEquals((Object)"Start change stream time", (Object)getResult4.documentation);
        Assertions.assertEquals((Object)"Start time", (Object)getResult4.displayName);
        Assertions.assertNull((Object)getResult4.defaultValue);
        ConfigDef.ConfigKey getResult5 = (ConfigDef.ConfigKey)configKeysResult.get("gcp.spanner.end.time");
        Assertions.assertNull((Object)getResult5.validator);
        Assertions.assertEquals((Object)ConfigDef.Type.STRING, (Object)getResult5.type);
        Assertions.assertNull((Object)getResult5.recommender);
        Assertions.assertEquals((int)6, (int)getResult5.orderInGroup);
        Assertions.assertEquals((Object)"gcp.spanner.end.time", (Object)getResult5.name);
        Assertions.assertFalse((boolean)getResult5.internalConfig);
        Assertions.assertEquals((Object)ConfigDef.Importance.MEDIUM, (Object)getResult5.importance);
        Assertions.assertEquals((Object)"Connector", (Object)getResult5.group);
        Assertions.assertEquals((Object)"End change stream time", (Object)getResult5.documentation);
        Assertions.assertEquals((Object)"End time", (Object)getResult5.displayName);
        Assertions.assertNull((Object)getResult5.defaultValue);
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult4.width);
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult5.width);
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult2.width);
        Assertions.assertEquals((Object)ConfigDef.Width.SHORT, (Object)getResult3.width);
    }

    @Test
    void testIsSchemaChangesHistoryEnabled() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertFalse((boolean)new SpannerConnectorConfig(configuration).isSchemaChangesHistoryEnabled());
    }

    @Test
    void testIsSchemaCommentsHistoryEnabled() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertFalse((boolean)new SpannerConnectorConfig(configuration).isSchemaCommentsHistoryEnabled());
    }

    @Test
    void testGetHeartbeatInterval() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Duration interval = new SpannerConnectorConfig(configuration).getHeartbeatInterval();
        Assertions.assertEquals((Object)Duration.of(300000L, ChronoUnit.MILLIS), (Object)interval);
    }

    @Test
    void testGetLowWatermarkStampInterval() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Duration interval = new SpannerConnectorConfig(configuration).getLowWatermarkStampInterval();
        Assertions.assertEquals((Object)Duration.of(10000L, ChronoUnit.MILLIS), (Object)interval);
    }

    @Test
    void testShouldProvideTransactionMetadata() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertFalse((boolean)new SpannerConnectorConfig(configuration).shouldProvideTransactionMetadata());
    }

    @Test
    void testProjectId() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).projectId());
    }

    @Test
    void testInstanceId() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).instanceId());
    }

    @Test
    void testDatabaseId() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).databaseId());
    }

    @Test
    void testChangeStreamName() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).changeStreamName());
    }

    @Test
    void testEndTime() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).endTime());
    }

    @Test
    void testQueueCapacity() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)10000, (int)new SpannerConnectorConfig(configuration).queueCapacity());
    }

    @Test
    void testGcpSpannerCredentialsJson() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).gcpSpannerCredentialsJson());
    }

    @Test
    void testGcpSpannerCredentialsPath() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).gcpSpannerCredentialsPath());
    }

    @Test
    void testTableExcludeList() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).tableExcludeList());
    }

    @Test
    void testTableIncludeList() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertNull((Object)new SpannerConnectorConfig(configuration).tableIncludeList());
    }

    @Test
    void testBootStrapServer() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((Object)"localhost:9092", (Object)new SpannerConnectorConfig(configuration).bootStrapServer());
    }

    @Test
    void testRebalancingTopic() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((Object)"_rebalancing_topic_spanner_connector_null", (Object)new SpannerConnectorConfig(configuration).rebalancingTopic());
    }

    @Test
    void testRebalancingPollDuration() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)5000, (int)new SpannerConnectorConfig(configuration).rebalancingPollDuration());
    }

    @Test
    void testRebalancingCommitOffsetsTimeout() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)5000, (int)new SpannerConnectorConfig(configuration).rebalancingCommitOffsetsTimeout());
    }

    @Test
    void testSyncPollDuration() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)500, (int)new SpannerConnectorConfig(configuration).syncPollDuration());
    }

    @Test
    void testSyncRequestTimeout() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)5000, (int)new SpannerConnectorConfig(configuration).syncRequestTimeout());
    }

    @Test
    void testSyncDeliveryTimeout() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)15000, (int)new SpannerConnectorConfig(configuration).syncDeliveryTimeout());
    }

    @Test
    void testTaskSyncTopic() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((Object)"_sync_topic_spanner_connector_null", (Object)new SpannerConnectorConfig(configuration).taskSyncTopic());
    }

    @Test
    void testGetMaxTasks() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)10, (int)new SpannerConnectorConfig(configuration).getMaxTasks());
    }

    @Test
    void testGetMinTasks() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)2, (int)new SpannerConnectorConfig(configuration).getMinTasks());
    }

    @Test
    void testGetDesiredPartitionsTasks() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((int)2, (int)new SpannerConnectorConfig(configuration).getDesiredPartitionsTasks());
    }

    @Test
    void testIsLowWatermarkEnabled() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertFalse((boolean)new SpannerConnectorConfig(configuration).isLowWatermarkEnabled());
    }

    @Test
    void testGetLowWatermarkUpdatePeriodMs() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Assertions.assertEquals((long)1000L, (long)new SpannerConnectorConfig(configuration).getLowWatermarkUpdatePeriodMs());
    }
}

