/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.config.Field;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.spanner.Module;
import io.debezium.connector.spanner.SpannerChangeEventSourceCoordinator;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.context.offset.SpannerOffsetContext;
import io.debezium.connector.spanner.processor.SourceRecordUtils;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.connect.source.SourceRecord;

public abstract class SpannerBaseSourceTask
extends BaseSourceTask<SpannerPartition, SpannerOffsetContext> {
    protected SpannerChangeEventSourceCoordinator coordinator;
    private final List<SourceRecord> records = new LinkedList<SourceRecord>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitRecord(SourceRecord sourceRecord, RecordMetadata metadata) throws InterruptedException {
        super.commitRecord(sourceRecord, metadata);
        SpannerBaseSourceTask spannerBaseSourceTask = this;
        synchronized (spannerBaseSourceTask) {
            this.records.add(sourceRecord);
        }
        if (metadata != null) {
            sourceRecord = SourceRecordUtils.addPublishTimestamp(sourceRecord, Instant.now().toEpochMilli());
        }
        this.onRecordSent(sourceRecord);
    }

    protected abstract void onRecordSent(SourceRecord var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws InterruptedException {
        super.commit();
        if (this.coordinator == null) {
            return;
        }
        SpannerBaseSourceTask spannerBaseSourceTask = this;
        synchronized (spannerBaseSourceTask) {
            this.coordinator.commitRecords(this.records);
            this.records.clear();
        }
    }

    protected Offsets<SpannerPartition, SpannerOffsetContext> getInitialOffsets() {
        return Offsets.of((Map)Collect.hashMapOf((Object)SpannerPartition.getInitialSpannerPartition(), null));
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return SpannerConnectorConfig.ALL_FIELDS;
    }

    public String version() {
        return Module.version();
    }
}

