/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor.metadata;

import io.debezium.connector.spanner.processor.metadata.EventFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

class EventFormatterTest {
    EventFormatterTest() {
    }

    @Test
    void testPrintStruct() {
        EventFormatter eventFormatter = new EventFormatter();
        Schema schema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).field("someField", Schema.STRING_SCHEMA).schema();
        Struct struct = new Struct(schema);
        eventFormatter.printStruct(struct);
        Assertions.assertTrue((boolean)eventFormatter.toString().contains("someField"));
    }

    @Test
    void testPrintStructOperationNull() {
        EventFormatter eventFormatter = new EventFormatter();
        Schema structSchema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).schema();
        Schema beforeSchema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).field("before", structSchema).schema();
        Schema afterSchema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).field("after", structSchema).schema();
        Schema schema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).field("someField", Schema.STRING_SCHEMA).field("op", Schema.STRING_SCHEMA).field("before", beforeSchema).field("after", afterSchema).schema();
        Struct value = (Struct)Mockito.spy((Object)new Struct(schema));
        ((Struct)Mockito.doReturn((Object)"testStructString").when((Object)value)).toString();
        ((Struct)Mockito.doReturn((Object)"testStructStringOperation").when((Object)value)).getString("op");
        eventFormatter.value(value);
        Assertions.assertTrue((boolean)eventFormatter.toString().contains("testStructStringOperation"));
    }

    @Test
    void testPrintStructOperationAddKeyInstanceofStruct() {
        EventFormatter eventFormatter = new EventFormatter();
        Schema structSchema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).schema();
        Schema beforeSchema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).field("before", structSchema).schema();
        Schema afterSchema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).field("after", structSchema).schema();
        Schema schema = SchemaBuilder.type((Schema.Type)Schema.Type.STRUCT).field("someField", Schema.STRING_SCHEMA).field("op", Schema.STRING_SCHEMA).field("before", beforeSchema).field("after", afterSchema).schema();
        Struct value = (Struct)Mockito.spy((Object)new Struct(schema));
        ((Struct)Mockito.doReturn((Object)"testStructString").when((Object)value)).toString();
        ((Struct)Mockito.doReturn((Object)"testStructStringOperation").when((Object)value)).getString("op");
        eventFormatter.value(value);
        Assertions.assertTrue((boolean)eventFormatter.toString().contains("testStructStringOperation"));
    }

    private static Stream<Arguments> toStringProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new EventFormatter().toString(), ""}), Arguments.of((Object[])new Object[]{new EventFormatter().sourcePosition(new HashMap()).toString(), "position: {}"}), Arguments.of((Object[])new Object[]{new EventFormatter().key((Object)"Key").toString(), "key: Key"}), Arguments.of((Object[])new Object[]{new EventFormatter().sourcePosition(Map.of("position: {", "42")).toString(), "position: {position: {: 42}"}));
    }

    @ParameterizedTest
    @MethodSource(value={"toStringProvider"})
    void testToString(Object string, String expected) {
        Assertions.assertTrue((boolean)expected.contains(string.toString()));
    }
}

