/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.leader.rebalancer;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.leader.rebalancer.TaskPartitionRebalancer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPartitionEqualSharingRebalancer
implements TaskPartitionRebalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskPartitionEqualSharingRebalancer.class);

    @Override
    public TaskState rebalance(TaskState leaderTaskState, Map<String, TaskState> survivedTasks, Map<String, TaskState> obsoleteTaskStates) {
        LOGGER.info("Leader task state {}", (Object)leaderTaskState);
        survivedTasks = this.excludeLeader(leaderTaskState.getTaskUid(), survivedTasks);
        LOGGER.info("Survived tasks {}", survivedTasks);
        LOGGER.info("Obsolete tasks {}", obsoleteTaskStates);
        TaskState newLeaderTaskState = this.moveFinishedPartitionsFromObsoleteTasks(leaderTaskState, obsoleteTaskStates);
        LOGGER.info("Leader task state after moving finished partitions from obsolete tasks {}", (Object)newLeaderTaskState);
        newLeaderTaskState = this.moveSharedPartitionsFromObsoleteTasks(newLeaderTaskState, survivedTasks, obsoleteTaskStates);
        LOGGER.info("Leader task state after moving finished partitions from obsolete tasks {}", (Object)newLeaderTaskState);
        newLeaderTaskState = this.takeSharedPartitionsFromSurvivedTasks(newLeaderTaskState, survivedTasks);
        LOGGER.info("Leader task state after moving shared partitions from survived tasks {}", (Object)newLeaderTaskState);
        newLeaderTaskState = this.takeSharedPartitionsToObsoleteTask(newLeaderTaskState, survivedTasks);
        LOGGER.info("Leader task state after moving shared partitions to obsolete tasks {}", (Object)newLeaderTaskState);
        newLeaderTaskState = this.distributePartitionsFromObsoleteTasks(newLeaderTaskState, survivedTasks, obsoleteTaskStates);
        LOGGER.info("Leader task state after distributing partitions from obsolete tasks {}", (Object)newLeaderTaskState);
        return newLeaderTaskState;
    }

    private Map<String, TaskState> excludeLeader(String leaderTaskUid, Map<String, TaskState> tasks) {
        tasks = new HashMap<String, TaskState>(tasks);
        tasks.remove(leaderTaskUid);
        return tasks;
    }

    private TaskState moveFinishedPartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> obsoleteTasks) {
        Set<String> tokens = this.collectPartitionTokens(Set.of(leaderTaskState));
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List<PartitionState> allPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        List finishedPartitions = allPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).map(partitionState -> {
            if (PartitionStateEnum.FINISHED.equals((Object)partitionState.getState())) {
                return partitionState.toBuilder().assigneeTaskUid(leaderTaskState.getTaskUid()).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        leaderPartitionList.addAll(finishedPartitions);
        return leaderTaskState.toBuilder().partitions(leaderPartitionList).build();
    }

    private TaskState distributePartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> survivedTasks, Map<String, TaskState> obsoleteTasks) {
        Set<String> tokens = this.collectPartitionTokens(Set.of(leaderTaskState), survivedTasks.values());
        List<PartitionState> allPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        List notFinishedPartitions = allPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).map(partitionState -> {
            if (!PartitionStateEnum.FINISHED.equals((Object)partitionState.getState()) && !PartitionStateEnum.REMOVED.equals((Object)partitionState.getState())) {
                return partitionState;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        for (PartitionState partitionState2 : notFinishedPartitions) {
            ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
            ArrayList<PartitionState> leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
            String taskUid = this.findCandidateToSharePartition(leaderTaskState, survivedTasks);
            if (!taskUid.equals(leaderTaskState.getTaskUid())) {
                leaderSharedPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            } else {
                leaderPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            }
            leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        }
        return leaderTaskState;
    }

    private String findCandidateToSharePartition(TaskState leaderTaskState, Map<String, TaskState> survivedTasks) {
        HashMap<String, TaskState> allTaskStates = new HashMap<String, TaskState>(survivedTasks);
        allTaskStates.put(leaderTaskState.getTaskUid(), leaderTaskState);
        Map<String, Integer> candidateMap = allTaskStates.values().stream().map(taskState -> {
            Set tokens = taskState.getPartitions().stream().filter(partitionState -> !PartitionStateEnum.FINISHED.equals((Object)partitionState.getState()) && !PartitionStateEnum.REMOVED.equals((Object)partitionState.getState())).map(PartitionState::getToken).collect(Collectors.toCollection(HashSet::new));
            Set assignedTokens = allTaskStates.values().stream().flatMap(taskState1 -> taskState1.getSharedPartitions().stream()).filter(partitionState -> partitionState.getAssigneeTaskUid().equals(taskState.getTaskUid())).map(PartitionState::getToken).collect(Collectors.toSet());
            tokens.addAll(assignedTokens);
            return new AbstractMap.SimpleEntry<String, Integer>(taskState.getTaskUid(), tokens.size());
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        Optional<Integer> minPartitionsValue = candidateMap.values().stream().min(Integer::compare);
        if (minPartitionsValue.isEmpty()) {
            return leaderTaskState.getTaskUid();
        }
        List finalCandidateList = candidateMap.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(minPartitionsValue.get())).map(Map.Entry::getKey).collect(Collectors.toList());
        int index = new Random().nextInt(finalCandidateList.size());
        return (String)finalCandidateList.get(index);
    }

    private TaskState moveSharedPartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> survivedTasks, Map<String, TaskState> obsoleteTasks) {
        Set<String> tokens = this.collectPartitionTokens(Set.of(leaderTaskState));
        Set<String> survivedOwnedTokens = this.collectOwnedPartitionTokens(survivedTasks.values());
        String leaderUid = leaderTaskState.getTaskUid();
        List<PartitionState> obsoleteTasksSharedPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toList()));
        ArrayList<PartitionState> leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List newSharedPartitions = obsoleteTasksSharedPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).map(partitionState -> {
            if (survivedTasks.containsKey(partitionState.getAssigneeTaskUid()) && !partitionState.getAssigneeTaskUid().equals(leaderUid)) {
                return partitionState;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        leaderSharedPartitionList.addAll(newSharedPartitions);
        leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        List newPartitions = obsoleteTasksSharedPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).map(partitionState -> {
            if (!survivedTasks.containsKey(partitionState.getAssigneeTaskUid()) || partitionState.getAssigneeTaskUid().equals(leaderUid)) {
                return partitionState;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        for (PartitionState partitionState2 : newPartitions) {
            String taskUid = this.findCandidateToSharePartition(leaderTaskState, survivedTasks);
            if (!taskUid.equals(leaderTaskState.getTaskUid())) {
                leaderSharedPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            } else {
                leaderPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            }
            leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        }
        return leaderTaskState;
    }

    private TaskState takeSharedPartitionsFromSurvivedTasks(TaskState leaderTaskState, Map<String, TaskState> survivedTasks) {
        Set<String> tokens = this.collectPartitionTokens(Set.of(leaderTaskState));
        Set<String> survivedOwnedTokens = this.collectOwnedPartitionTokens(survivedTasks.values());
        String leaderUid = leaderTaskState.getTaskUid();
        List partitions = this.filterDuplications(survivedTasks.values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toList())).stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).filter(partitionState -> !survivedTasks.containsKey(partitionState.getAssigneeTaskUid())).filter(partitionState -> !leaderUid.equals(partitionState.getAssigneeTaskUid())).collect(Collectors.toList());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        ArrayList<PartitionState> leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
        for (PartitionState partitionState2 : partitions) {
            String taskUid = this.findCandidateToSharePartition(leaderTaskState, survivedTasks);
            if (!taskUid.equals(leaderUid)) {
                leaderSharedPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            } else {
                leaderPartitionList.add(partitionState2.toBuilder().assigneeTaskUid(taskUid).state(PartitionStateEnum.CREATED).build());
            }
            leaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
        }
        return leaderTaskState;
    }

    private TaskState takeSharedPartitionsToObsoleteTask(TaskState leaderTaskState, Map<String, TaskState> survivedTasks) {
        Set<String> tokens = leaderTaskState.getPartitionsMap().keySet();
        Set<String> survivedOwnedTokens = this.collectOwnedPartitionTokens(survivedTasks.values());
        List partitions = leaderTaskState.getSharedPartitions().stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).filter(partitionState -> !survivedOwnedTokens.contains(partitionState.getToken())).filter(partitionState -> !survivedTasks.containsKey(partitionState.getAssigneeTaskUid())).map(partitionState -> partitionState.toBuilder().assigneeTaskUid(leaderTaskState.getTaskUid()).build()).collect(Collectors.toList());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        leaderPartitionList.addAll(partitions);
        TaskState newLeaderTaskState = leaderTaskState.toBuilder().partitions(leaderPartitionList).build();
        List<PartitionState> leaderSharedPartitionList = leaderTaskState.getSharedPartitions().stream().filter(partitionState -> !newLeaderTaskState.getPartitionsMap().containsKey(partitionState.getToken())).collect(Collectors.toList());
        return newLeaderTaskState.toBuilder().sharedPartitions(leaderSharedPartitionList).build();
    }

    private List<PartitionState> filterDuplications(List<PartitionState> partitionStates) {
        return partitionStates.stream().collect(Collectors.groupingBy(PartitionState::getToken)).values().stream().flatMap(list -> list.stream().sorted().limit(1L)).collect(Collectors.toList());
    }

    private Set<String> collectPartitionTokens(Collection<TaskState> ... taskStates) {
        return Arrays.stream(taskStates).flatMap(Collection::stream).flatMap(taskState -> Stream.concat(taskState.getPartitionsMap().keySet().stream(), taskState.getSharedPartitionsMap().keySet().stream())).collect(Collectors.toSet());
    }

    private Set<String> collectOwnedPartitionTokens(Collection<TaskState> ... taskStates) {
        return Arrays.stream(taskStates).flatMap(Collection::stream).flatMap(taskState -> taskState.getPartitionsMap().keySet().stream()).collect(Collectors.toSet());
    }
}

