/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.TaskSyncPublisher;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceState;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.LoggerUtils;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import io.debezium.connector.spanner.task.leader.LeaderAction;
import io.debezium.connector.spanner.task.leader.LowWatermarkStampPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebalanceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RebalanceHandler.class);
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final TaskSyncPublisher taskSyncPublisher;
    private final LeaderAction leaderAction;
    private final LowWatermarkStampPublisher lowWatermarkStampPublisher;

    public RebalanceHandler(TaskSyncContextHolder taskSyncContextHolder, TaskSyncPublisher taskSyncPublisher, LeaderAction leaderAction, LowWatermarkStampPublisher lowWatermarkStampPublisher) {
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.taskSyncPublisher = taskSyncPublisher;
        this.leaderAction = leaderAction;
        this.lowWatermarkStampPublisher = lowWatermarkStampPublisher;
    }

    public void process(boolean isLeader, String consumerId, long rebalanceGenerationId) throws InterruptedException {
        LOGGER.info("processRebalancingEvent: start, consumerId: {}, rebalanceGenerationId: {}", (Object)consumerId, (Object)rebalanceGenerationId);
        this.leaderAction.stop();
        TaskSyncContext context = this.taskSyncContextHolder.updateAndGet(oldContext -> {
            TaskState updatedState = oldContext.getCurrentTaskState().toBuilder().consumerId(consumerId).rebalanceGenerationId(rebalanceGenerationId).build();
            return oldContext.toBuilder().consumerId(consumerId).rebalanceGenerationId(rebalanceGenerationId).currentTaskState(updatedState).isLeader(isLeader).rebalanceState(RebalanceState.INITIAL_INCREMENTED_STATE_COMPLETED).build();
        });
        TaskSyncEvent taskSyncEvent = context.buildTaskSyncEvent(MessageTypeEnum.REBALANCE_ANSWER);
        LoggerUtils.debug(LOGGER, "processRebalancingEvent: send: {}", taskSyncEvent);
        LOGGER.info("Task {} - RebalanceHandler sent sync event", (Object)taskSyncEvent.getTaskUid());
        this.taskSyncPublisher.send(taskSyncEvent);
        LOGGER.info("processRebalancingEvent: Task {} rebalance answer has been sent", (Object)this.taskSyncContextHolder.get().getTaskUid());
        if (isLeader) {
            LOGGER.info("Task {} is leader", (Object)context.getTaskUid());
            this.leaderAction.start();
            this.lowWatermarkStampPublisher.start();
        } else {
            this.lowWatermarkStampPublisher.suspend();
        }
    }

    public void init() {
        this.lowWatermarkStampPublisher.init();
    }

    public void destroy() {
        this.leaderAction.stop();
        try {
            this.lowWatermarkStampPublisher.destroy();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

