/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.metadata;

import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.schema.Column;
import io.debezium.connector.spanner.db.model.schema.SpannerSchema;
import io.debezium.connector.spanner.db.model.schema.TableSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SchemaMerger {
    private SchemaMerger() {
    }

    public static SpannerSchema merge(SpannerSchema previousSchema, SpannerSchema newSchema) {
        HashMap<TableId, TableSchema> tables = new HashMap<TableId, TableSchema>();
        newSchema.getAllTables().forEach(tableId -> {
            TableSchema oldTableSchema = previousSchema.getTable((TableId)tableId);
            if (oldTableSchema == null) {
                tables.put((TableId)tableId, newSchema.getTable((TableId)tableId));
            } else {
                TableSchema mergedTable = SchemaMerger.mergeTable(oldTableSchema, newSchema.getTable((TableId)tableId));
                tables.put((TableId)tableId, mergedTable);
            }
        });
        return new SpannerSchema(tables);
    }

    private static TableSchema mergeTable(TableSchema previousTableSchema, TableSchema newTableSchema) {
        Map columnMap = newTableSchema.columns().stream().collect(Collectors.toMap(Column::getName, Function.identity()));
        ArrayList<Column> newColumns = new ArrayList<Column>(columnMap.values());
        newColumns.addAll(previousTableSchema.columns().stream().filter(column -> !columnMap.containsKey(column.getName())).collect(Collectors.toList()));
        return new TableSchema(newTableSchema.getName(), newColumns);
    }
}

