/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor;

import io.debezium.connector.spanner.processor.SourceRecordUtils;
import java.util.HashMap;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SourceRecordUtilsTest {
    SourceRecordUtilsTest() {
    }

    @Test
    void testExtractRecordUid() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)SourceRecordUtils.extractRecordUid((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testIsDataChangeRecord() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertFalse((boolean)SourceRecordUtils.isDataChangeRecord((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testFrom() {
        Assertions.assertFalse((boolean)SourceRecordUtils.from((String)"1234").isEmpty());
    }

    @Test
    void testAddEmitTimestamp() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertFalse((boolean)SourceRecordUtils.addEmitTimestamp((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"), (long)10L).headers().isEmpty());
    }

    @Test
    void testAddPublishTimestamp() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertFalse((boolean)SourceRecordUtils.addPublishTimestamp((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"), (long)10L).headers().isEmpty());
    }

    @Test
    void testAddPollTimestamp() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertFalse((boolean)SourceRecordUtils.addPollTimestamp((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value"), (long)10L).headers().isEmpty());
    }

    @Test
    void testExtractToken() {
        HashMap sourcePartition = new HashMap();
        HashMap sourceOffset = new HashMap();
        Assertions.assertNull((Object)SourceRecordUtils.extractToken((SourceRecord)new SourceRecord(sourcePartition, sourceOffset, "Topic", (Schema)new ConnectSchema(Schema.Type.INT8), (Object)"Value")));
    }

    @Test
    void testExtractPublishTimestamp() {
        ConnectHeaders fromResult = SourceRecordUtils.from((String)"1234");
        fromResult.addLong("publishAtTimestamp", 42L);
        SourceRecord sourceRecord = (SourceRecord)Mockito.mock(SourceRecord.class);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)fromResult);
        Assertions.assertEquals((long)42L, (long)SourceRecordUtils.extractPublishTimestamp((SourceRecord)sourceRecord));
    }

    @Test
    void testExtractPollTimestamp() {
        ConnectHeaders fromResult = SourceRecordUtils.from((String)"1234");
        fromResult.addLong("pollAtTimestamp", 42L);
        SourceRecord sourceRecord = (SourceRecord)Mockito.mock(SourceRecord.class);
        Mockito.when((Object)sourceRecord.headers()).thenReturn((Object)fromResult);
        Assertions.assertEquals((long)42L, (long)SourceRecordUtils.extractPollTimestamp((SourceRecord)sourceRecord));
    }
}

