/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerSourceInfoStructMaker;
import io.debezium.connector.spanner.context.source.SourceInfo;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SpannerSourceInfoStructMakerTest {
    SpannerSourceInfoStructMakerTest() {
    }

    @Test
    void testConstructor() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        Schema schemaResult = new SpannerSourceInfoStructMaker("Connector", "1.0.2", (CommonConnectorConfig)new SpannerConnectorConfig(configuration)).schema();
        Assertions.assertTrue((boolean)(schemaResult instanceof ConnectSchema));
        Assertions.assertNull((Object)schemaResult.defaultValue());
        Assertions.assertNull((Object)schemaResult.version());
        Assertions.assertEquals((Object)Schema.Type.STRUCT, (Object)schemaResult.type());
        Assertions.assertNull((Object)schemaResult.parameters());
        Assertions.assertEquals((Object)"com.google.spanner.connector.Source", (Object)schemaResult.name());
        Assertions.assertFalse((boolean)schemaResult.isOptional());
        List fieldsResult = schemaResult.fields();
        Assertions.assertEquals((int)23, (int)fieldsResult.size());
        Assertions.assertNull((Object)schemaResult.doc());
        org.apache.kafka.connect.data.Field getResult = (org.apache.kafka.connect.data.Field)fieldsResult.get(0);
        Assertions.assertTrue((boolean)(getResult.schema() instanceof ConnectSchema));
        org.apache.kafka.connect.data.Field getResult1 = (org.apache.kafka.connect.data.Field)fieldsResult.get(1);
        Assertions.assertTrue((boolean)(getResult1.schema() instanceof ConnectSchema));
        org.apache.kafka.connect.data.Field getResult2 = (org.apache.kafka.connect.data.Field)fieldsResult.get(17);
        Assertions.assertTrue((boolean)(getResult2.schema() instanceof ConnectSchema));
        Assertions.assertEquals((int)17, (int)getResult2.index());
        Assertions.assertEquals((int)0, (int)getResult.index());
        Assertions.assertEquals((Object)"version", (Object)getResult.name());
        Assertions.assertEquals((Object)"system_transaction", (Object)getResult2.name());
        Assertions.assertEquals((int)1, (int)getResult1.index());
        Assertions.assertEquals((Object)"connector", (Object)getResult1.name());
        org.apache.kafka.connect.data.Field getResult3 = (org.apache.kafka.connect.data.Field)fieldsResult.get(16);
        Assertions.assertEquals((int)16, (int)getResult3.index());
        Assertions.assertEquals((Object)"transaction_tag", (Object)getResult3.name());
    }

    @Test
    void testSchema() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerSourceInfoStructMaker connector = new SpannerSourceInfoStructMaker("Connector", "1.0.2", (CommonConnectorConfig)new SpannerConnectorConfig(configuration));
        Assertions.assertNotNull((Object)connector.schema());
        Assertions.assertTrue((boolean)(connector.schema() instanceof ConnectSchema));
    }

    @Test
    void testStruct() {
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration.asProperties()).thenReturn((Object)new Properties());
        SpannerSourceInfoStructMaker spannerSourceInfoStructMaker = new SpannerSourceInfoStructMaker("Connector", "1.0.2", (CommonConnectorConfig)new SpannerConnectorConfig(configuration));
        Configuration configuration1 = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration1.getString((Field)Mockito.any())).thenReturn((Object)"String");
        Mockito.when((Object)configuration1.getString(ArgumentMatchers.anyString())).thenReturn((Object)"String");
        Mockito.when((Object)configuration1.asProperties()).thenReturn((Object)new Properties());
        SpannerConnectorConfig connectorConfig = new SpannerConnectorConfig(configuration1);
        LocalDateTime atStartOfDayResult = LocalDate.of(1970, 1, 1).atStartOfDay();
        Instant recordTimestamp = atStartOfDayResult.atZone(ZoneId.of("UTC")).toInstant();
        LocalDateTime atStartOfDayResult1 = LocalDate.of(1970, 1, 1).atStartOfDay();
        Instant commitTimestamp = atStartOfDayResult1.atZone(ZoneId.of("UTC")).toInstant();
        LocalDateTime atStartOfDayResult2 = LocalDate.of(1970, 1, 1).atStartOfDay();
        Instant readAtTimestamp = atStartOfDayResult2.atZone(ZoneId.of("UTC")).toInstant();
        LocalDateTime atStartOfDayResult3 = LocalDate.of(1970, 1, 1).atStartOfDay();
        SourceInfo sourceInfo = new SourceInfo(connectorConfig, "Table Name", recordTimestamp, commitTimestamp, readAtTimestamp, "42", Long.valueOf(1L), atStartOfDayResult3.atZone(ZoneId.of("UTC")).toInstant(), Long.valueOf(1L), "testTag=test", Boolean.valueOf(false), "UPDATE", "testToken", Integer.valueOf(0), Boolean.valueOf(false), Long.valueOf(1L));
        Assertions.assertThrows(IllegalStateException.class, () -> spannerSourceInfoStructMaker.struct(sourceInfo));
    }
}

